/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.unittesting.astassertion;

import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.utils.Console;
import io.openvalidation.common.utils.StringUtils;
import java.util.List;

public class ASTAssertionBase<P extends ASTAssertionBase> {
    protected String _name = "";
    protected int _index = 0;
    protected ASTModel ast;
    protected P parent;

    public ASTAssertionBase(String name, ASTModel ast, P parent) {
        this(name, 0, ast, parent);
    }

    public ASTAssertionBase(String name, int index, ASTModel ast, P parent) {
        this._name = name;
        this._index = index;
        this.ast = ast;
        this.parent = parent;
    }

    protected void writeExpectedAndActual(String expected, String actual) {
        this.error(this.getExpectedPrefix() + expected + "\n" + this.getActualPrefix() + actual);
    }

    protected void writeExpected(String message) {
        this.error(this.getExpectedPrefix() + message);
    }

    protected void writeActual(String message) {
        this.error(this.getActualPrefix() + message);
    }

    protected void info(String message) {
        Console.print("\n" + message);
    }

    protected void error(String message) {
        try {
            Console.error("\n" + message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.ast != null) {
            System.out.println("\n\n" + this.ast.print() + "\n\n");
        } else {
            System.out.println("\n\nAST MODEL is NULL\n\n");
        }
        throw new RuntimeException();
    }

    protected String getExpectedPrefix() {
        return "EXPECTED  " + this._name + this.getPositionString();
    }

    protected String getActualPrefix() {
        return "ACTUAL    " + this._name + this.getPositionString();
    }

    protected String getPositionString() {
        if (!StringUtils.isNullOrEmpty(this.getIdentifier())) {
            return " '" + this.getIdentifier() + "' ";
        }
        return this._index > -1 ? " at Position [" + this._index + "] " : " ";
    }

    protected String getIdentifier() {
        return null;
    }

    protected ASTAssertionBase shouldNotBeEmpty() {
        return this;
    }

    public P parent() {
        return this.parent;
    }

    protected <A extends ASTAssertionBase> A parentAssertion(Class<A> cls) {
        this.shouldBeInstanceOf(this.parent(), cls, "PARENT");
        return (A)this.parent;
    }

    protected void shouldBeTrue(boolean value, String name) {
        if (!value) {
            this.writeExpectedAndActual(name + " : true", name + " : false");
        }
    }

    protected void shouldBeFalse(boolean value, String name) {
        if (value) {
            this.writeExpectedAndActual(name + " : false", name + " : true");
        }
    }

    protected void shouldNotBeNull(Object obj, String name) {
        if (obj == null) {
            this.writeExpected(name + " should not be null");
        }
    }

    protected void shouldNotBeEmpty(Object obj, String name) {
        if (obj == null) {
            this.writeExpected(name + " should not be null");
        }
    }

    protected void shouldNotBeEmpty(String obj, String name) {
        if (obj == null) {
            this.writeExpected(name + " should not be null");
        }
        if (obj.length() < 1) {
            this.writeExpected(name + " should not be empty");
        }
    }

    protected <A> void shouldNotBeEmpty(List<A> list, String name) {
        if (list == null) {
            this.writeExpected(name + " should not be null");
        }
        if (list.size() < 1) {
            this.writeExpected(name + " should not be empty");
        }
    }

    protected void shouldBeNull(Object obj, String name) {
        if (obj != null) {
            this.writeExpected(name + " should be null or empty");
        }
    }

    protected void shouldStartsWith(String actual, String expectedStart, String name) {
        if (!actual.startsWith(expectedStart)) {
            this.writeExpectedAndActual(name + " : " + expectedStart, name + " : " + actual);
        }
    }

    protected void shouldEquals(String actual, String expected, String name) {
        if (!actual.equals(expected)) {
            this.writeExpectedAndActual(name + " : " + expected, name + " : " + actual);
        }
    }

    protected <E extends Enum<E>> void shouldEquals(E actual, E expected, String name) {
        if (actual != expected) {
            this.writeExpectedAndActual(name + " : " + expected, name + " : " + actual);
        }
    }

    protected void shouldEquals(Double actual, Double expected, String name) {
        if (!actual.equals(expected)) {
            this.writeExpectedAndActual(name + " : " + expected, name + " : " + actual);
        }
    }

    protected void shouldEquals(Integer actual, Integer expected, String name) {
        if (!actual.equals(expected)) {
            this.writeExpectedAndActual(name + " : " + expected, name + " : " + actual);
        }
    }

    protected void shouldEquals(boolean actual, boolean expected, String name) {
        if (actual != expected) {
            this.writeExpectedAndActual(name + " : " + expected, name + " : " + actual);
        }
    }

    protected <C> void shouldBeInstanceOf(Object actual, Class<C> expected, String name) {
        this.shouldNotBeNull(actual, name);
        boolean isInstance = expected.isInstance(actual);
        if (!isInstance) {
            this.writeExpectedAndActual(name + " ist not of Type: " + expected.getSimpleName(), name + " is of Type: " + actual.getClass().getSimpleName());
        }
    }

    protected void shouldContains(List<String> list, String expected, String name) {
        this.shouldNotBeEmpty(list, name);
        if (!list.contains(expected)) {
            this.writeExpectedAndActual(name + " " + expected, name + " : " + String.join((CharSequence)", ", list));
        }
    }

    protected <A> void shouldHaveSizeOf(List<A> list, int expectedSize, String name) {
        this.shouldNotBeNull(list, "LIST with " + name);
        if (list.size() != expectedSize) {
            this.writeExpectedAndActual("SIZE of " + name + " : " + expectedSize, "SIZE of " + name + " is: " + list.size());
        }
    }

    protected <A> void shouldHaveMinSizeOf(List<A> list, int expectedMinSize, String name) {
        this.shouldNotBeNull(list, "LIST with " + name);
        if (list.size() < expectedMinSize) {
            this.writeExpectedAndActual("SIZE of " + name + " : " + expectedMinSize, "SIZE of " + name + " : " + list.size());
        }
    }

    protected <A> void shouldNotBeOutOfRange(List<A> list, int index) {
        this.shouldNotBeNull(list, "LIST");
        if (index < 0) {
            this.writeExpected("INDEX should not be smaller than 0");
        }
        if (index >= list.size()) {
            this.writeExpectedAndActual(" INDEX : " + index + " out of Range", " SIZE: " + list.size());
        }
    }
}

