/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.unittesting.astassertion;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.unittesting.astassertion.ASTArithmeticalOperationAssertion;
import io.openvalidation.common.unittesting.astassertion.ASTAssertionBase;
import io.openvalidation.common.unittesting.astassertion.ArithmeticOperandAssertion;
import io.openvalidation.common.unittesting.astassertion.ConditionAssertion;
import io.openvalidation.common.unittesting.astassertion.ModelRootAssertion;
import io.openvalidation.common.unittesting.astassertion.OperandArithmeticalAssertion;
import io.openvalidation.common.unittesting.astassertion.OperandAssertion;

public class ASTItemAssertionBase<T extends ASTItem, P extends ASTAssertionBase, S extends ASTAssertionBase>
extends ASTAssertionBase<P> {
    protected T model;

    public ASTItemAssertionBase(T item, ASTModel ast, P parent) {
        super(item != null ? item.getClass().getSimpleName() : "UNKNOWN", ast, parent);
        this.model = item;
    }

    public ASTItemAssertionBase(T item, String name, ASTModel ast, P parent) {
        super(name, ast, parent);
        this.model = item;
    }

    public ASTItemAssertionBase(T item, String name, int index, ASTModel ast, P parent) {
        super(name, index, ast, parent);
        this.model = item;
    }

    public ASTItemAssertionBase(T item, int index, ASTModel ast, P parent) {
        super(item != null ? item.getClass().getSimpleName() : "UNKNOWN", index, ast, parent);
        this.model = item;
    }

    @Override
    protected ASTItemAssertionBase<T, P, S> shouldNotBeEmpty() {
        this.shouldNotBeNull(this.model, "");
        return this;
    }

    public S hasOriginalSource(String source) throws Exception {
        this.hasOriginalSource();
        this.shouldEquals(((ASTItem)this.model).getOriginalSource(), source, "ORIGINAL SOURCE");
        return (S)this;
    }

    public S hasOriginalSource() throws Exception {
        this.shouldNotBeEmpty();
        if (this.model != null && ((ASTItem)this.model).getPreprocessedSource() != null) {
            this.shouldNotBeEmpty(((ASTItem)this.model).getPreprocessedSource(), "ORIGINAL SOURCE");
        } else {
            this.writeExpected("PREPROCESSED SOURCE should not be null");
        }
        return (S)this;
    }

    public S hasPreprocessedSource(String source) throws Exception {
        this.hasPreprocessedSource();
        this.shouldEquals(((ASTItem)this.model).getPreprocessedSource(), source, "PREPROCESSED SOURCE");
        return (S)this;
    }

    public S hasPreprocessedSource() throws Exception {
        this.shouldNotBeEmpty();
        if (this.model != null && ((ASTItem)this.model).getPreprocessedSource() != null) {
            this.shouldNotBeEmpty(((ASTItem)this.model).getPreprocessedSource(), "PREPROCESSED SOURCE");
        } else {
            this.writeExpected("PREPROCESSED SOURCE should not be null");
        }
        return (S)this;
    }

    public OperandAssertion parentOperand() {
        this.shouldBeInstanceOf(this.parent(), OperandAssertion.class, "PARENT OPERAND");
        return (OperandAssertion)this.parent();
    }

    public ASTArithmeticalOperationAssertion parentOperation() {
        return this.parentArithmeticOperand().parentOperation();
    }

    public ConditionAssertion parentCondition() {
        return this.parentOperand().parentCondition();
    }

    public ModelRootAssertion parentModel() {
        return this.parentCondition().parentModel();
    }

    public ArithmeticOperandAssertion parentArithmeticOperand() {
        this.shouldBeInstanceOf(this.parent(), ArithmeticOperandAssertion.class, "PARENT ARITHMETIC OPERAND");
        return (ArithmeticOperandAssertion)this.parent();
    }

    public OperandArithmeticalAssertion parentArithmetic() {
        this.shouldBeInstanceOf(this.parentArithmeticOperand().parent(), OperandArithmeticalAssertion.class, "PARENT ARITHMETIC");
        return (OperandArithmeticalAssertion)this.parentArithmeticOperand().parent();
    }
}

