/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.unittesting.astassertion;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.unittesting.astassertion.ASTAssertionBase;
import io.openvalidation.common.unittesting.astassertion.ConditionAssertion;
import io.openvalidation.common.unittesting.astassertion.ModelRootAssertion;
import io.openvalidation.common.unittesting.astassertion.OperandAssertion;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ASTListAssertionBase<A extends ASTItem, T extends ASTAssertionBase, P extends ASTAssertionBase>
extends ASTAssertionBase<P> {
    protected List<T> children = new ArrayList<T>();

    public ASTListAssertionBase(String name, ASTModel ast, P parent) {
        super(name, -1, ast, parent);
    }

    protected void fillList(List<A> items, Function<A, T> action) {
        if (items != null) {
            items.forEach(c -> this.children.add(action.apply(c)));
        }
    }

    public ASTListAssertionBase<A, T, P> hasSizeOf(int size) {
        this.shouldNotBeEmpty();
        this.shouldHaveSizeOf(this.children, size, "LIST");
        return this;
    }

    @Override
    public ASTListAssertionBase<A, T, P> shouldNotBeEmpty() {
        this.children.forEach(c -> {
            try {
                c.shouldNotBeEmpty();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return this;
    }

    public T first() {
        return this.atIndex(0);
    }

    public T second() {
        return this.atIndex(1);
    }

    public T third() {
        return this.atIndex(2);
    }

    public T atIndex(int index) {
        this.shouldNotBeEmpty();
        this.shouldNotBeOutOfRange(this.children, index);
        return (T)((ASTAssertionBase)this.children.get(index));
    }

    public ModelRootAssertion parentRoot() {
        this.shouldBeInstanceOf(this.parent, ModelRootAssertion.class, "PARENT VARIABLE");
        return (ModelRootAssertion)this.parent();
    }

    public ConditionAssertion parentCondition() {
        this.shouldBeInstanceOf(this.parent(), OperandAssertion.class, "PARENT CONDITION");
        return ((OperandAssertion)this.parent()).parentCondition();
    }
}

