/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.unittesting.astassertion;

import io.openvalidation.common.ast.ASTArithmeticalOperator;
import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandStaticNumber;
import io.openvalidation.common.ast.operand.ASTOperandStaticString;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmetical;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmeticalItemBase;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmeticalNumberItem;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmeticalOperation;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmeticalPropertyItem;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmeticalStringItem;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmeticalVariable;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.unittesting.astassertion.ASTArithmeticalOperationAssertion;
import io.openvalidation.common.unittesting.astassertion.ASTAssertionBase;
import io.openvalidation.common.unittesting.astassertion.ASTItemAssertionBase;
import io.openvalidation.common.unittesting.astassertion.OperandArithmeticalAssertion;
import io.openvalidation.common.unittesting.astassertion.PropertyAssertion;
import io.openvalidation.common.unittesting.astassertion.StaticNumberAssertion;
import io.openvalidation.common.unittesting.astassertion.StaticStringAssertion;
import io.openvalidation.common.unittesting.astassertion.VariableReferenceAssertion;

public class ArithmeticOperandAssertion
extends ASTItemAssertionBase<ASTOperandArithmeticalItemBase, ASTAssertionBase, ArithmeticOperandAssertion> {
    public ArithmeticOperandAssertion(ASTOperandArithmeticalItemBase item, int index, ASTModel ast, ASTAssertionBase parent) {
        super(item, index, ast, parent);
    }

    public ArithmeticOperandAssertion(ASTOperandArithmeticalItemBase item, ASTModel ast, ASTAssertionBase parent) {
        super(item, ast, parent);
    }

    public StaticNumberAssertion staticNumber() throws Exception {
        return this.getAssertion(StaticNumberAssertion.class, ASTOperandArithmeticalNumberItem.class, ASTOperandStaticNumber.class, "NUMBER");
    }

    public ArithmeticOperandAssertion hasOperator(ASTArithmeticalOperator operator) {
        this.shouldEquals(((ASTOperandArithmeticalItemBase)this.model).getOperator(), operator, "Operator Type");
        return this;
    }

    public ArithmeticOperandAssertion hasNoOperator() {
        this.shouldBeNull((Object)((ASTOperandArithmeticalItemBase)this.model).getOperator(), "ARITHMETICAL OPERATOR");
        return this;
    }

    public ArithmeticOperandAssertion hasNoOperand() {
        this.shouldBeNull(((ASTOperandArithmeticalItemBase)this.model).getOperand(), "OPERAND OF ARITHMETICAL ITEM");
        return this;
    }

    public ArithmeticOperandAssertion staticNumber(Double number) throws Exception {
        return (ArithmeticOperandAssertion)this.staticNumber().hasValue(number).parent();
    }

    public StaticStringAssertion staticString() throws Exception {
        return this.getAssertion(StaticStringAssertion.class, ASTOperandArithmeticalStringItem.class, ASTOperandStaticString.class, "STRING");
    }

    public ArithmeticOperandAssertion staticString(String value) throws Exception {
        return (ArithmeticOperandAssertion)this.staticString().hasValue(value).parent();
    }

    public PropertyAssertion propertyValue() throws Exception {
        return this.getAssertion(PropertyAssertion.class, ASTOperandArithmeticalPropertyItem.class, ASTOperandProperty.class, "PROPERTY");
    }

    public VariableReferenceAssertion variableValue() throws Exception {
        return this.getAssertion(VariableReferenceAssertion.class, ASTOperandArithmeticalVariable.class, ASTOperandVariable.class, "VARIABLE");
    }

    public ArithmeticOperandAssertion arithmeticValue() throws Exception {
        return this.getAssertion(ArithmeticOperandAssertion.class, ASTOperandArithmeticalOperation.class, ASTOperandArithmetical.class, "ARITHMETICAL OPERATION");
    }

    public <S extends ASTAssertionBase, T extends ASTItem, O extends ASTOperandBase> S getAssertion(Class<S> assrt, Class<T> cls, Class<O> operandCls, String name) throws Exception {
        this.shouldNotBeEmpty();
        this.shouldNotBeNull(((ASTOperandArithmeticalItemBase)this.model).getOperand(), name);
        this.shouldBeInstanceOf(this.model, cls, name);
        this.shouldBeInstanceOf(((ASTOperandArithmeticalItemBase)this.model).getOperand(), operandCls, name);
        return (S)((ASTAssertionBase)assrt.getDeclaredConstructors()[0].newInstance(((ASTOperandArithmeticalItemBase)this.model).getOperand(), this.ast, this));
    }

    @Override
    public OperandArithmeticalAssertion parentArithmetic() {
        this.shouldBeInstanceOf(this.parent(), OperandArithmeticalAssertion.class, "PARENT ARITHMETIC");
        return (OperandArithmeticalAssertion)this.parent();
    }

    @Override
    public ASTArithmeticalOperationAssertion parentOperation() {
        this.shouldBeInstanceOf(this.parent(), ASTArithmeticalOperationAssertion.class, "PARENT OPERATION");
        return (ASTArithmeticalOperationAssertion)this.parent;
    }
}

