/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.unittesting.astassertion;

import io.openvalidation.common.ast.ASTComparisonOperator;
import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.condition.ASTConditionConnector;
import io.openvalidation.common.ast.operand.ASTOperandArray;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandFunction;
import io.openvalidation.common.ast.operand.ASTOperandStatic;
import io.openvalidation.common.ast.operand.ASTOperandStaticNumber;
import io.openvalidation.common.ast.operand.ASTOperandStaticString;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmetical;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.unittesting.astassertion.ASTArithmeticalOperationAssertion;
import io.openvalidation.common.unittesting.astassertion.ASTAssertionBase;
import io.openvalidation.common.unittesting.astassertion.ArrayAssertion;
import io.openvalidation.common.unittesting.astassertion.ConditionAssertionBase;
import io.openvalidation.common.unittesting.astassertion.ConditionGroupAssertion;
import io.openvalidation.common.unittesting.astassertion.FunctionAssertion;
import io.openvalidation.common.unittesting.astassertion.LambdaAssertion;
import io.openvalidation.common.unittesting.astassertion.ModelRootAssertion;
import io.openvalidation.common.unittesting.astassertion.OperandArithmeticalAssertion;
import io.openvalidation.common.unittesting.astassertion.OperandAssertion;
import io.openvalidation.common.unittesting.astassertion.PropertyAssertion;
import io.openvalidation.common.unittesting.astassertion.RuleAssertion;
import io.openvalidation.common.unittesting.astassertion.StaticBoolAssertion;
import io.openvalidation.common.unittesting.astassertion.StaticNumberAssertion;
import io.openvalidation.common.unittesting.astassertion.StaticStringAssertion;
import io.openvalidation.common.unittesting.astassertion.VariableAssertion;
import io.openvalidation.common.unittesting.astassertion.VariableReferenceAssertion;
import io.openvalidation.common.unittesting.astassertion.lists.RuleListAssertion;

public class ConditionAssertion
extends ConditionAssertionBase<ASTCondition, ConditionAssertion> {
    public ConditionAssertion(ASTCondition item, int index, ASTModel ast, ASTAssertionBase parent) {
        super(item, index, ast, parent);
    }

    public ConditionAssertion(ASTCondition item, ASTModel ast, ASTAssertionBase parent) {
        super(item, ast, parent);
    }

    public ConditionAssertion hasOperator() {
        this.shouldNotBeEmpty((Object)((ASTCondition)this.model).getOperator(), "OPERATOR");
        return this;
    }

    public ConditionAssertion hasNoOperator() {
        this.shouldBeNull((Object)((ASTCondition)this.model).getOperator(), "OPERATOR");
        return this;
    }

    public ConditionAssertion hasIndentationLevel(int indentationLevel) {
        this.shouldNotBeEmpty(((ASTCondition)this.model).getIndentationLevel(), "INDENTATION LEVEL");
        this.shouldEquals(((ASTCondition)this.model).getIndentationLevel(), indentationLevel, "INDENTATION LEVEL");
        return this;
    }

    public ConditionAssertion hasOperator(ASTComparisonOperator operator) {
        this.shouldNotBeEmpty((Object)((ASTCondition)this.model).getOperator(), "OPERATOR");
        this.shouldEquals(((ASTCondition)this.model).getOperator(), operator, "OPERATOR");
        return this;
    }

    public OperandAssertion leftOperand() {
        this.shouldNotBeEmpty(((ASTCondition)this.model).getLeftOperand(), "LEFT OPERAND");
        return new OperandAssertion(((ASTCondition)this.model).getLeftOperand(), this.ast, this);
    }

    public OperandAssertion rightOperand() {
        this.shouldNotBeEmpty(((ASTCondition)this.model).getRightOperand(), "RIGHT OPERAND");
        return new OperandAssertion(((ASTCondition)this.model).getRightOperand(), this.ast, this);
    }

    public FunctionAssertion leftFunction() throws Exception {
        OperandAssertion leftOperand = this.leftOperand();
        return leftOperand.getAssertion(FunctionAssertion.class, ASTOperandFunction.class, "LEFT OPERAND FUNCTION");
    }

    public PropertyAssertion leftProperty() throws Exception {
        OperandAssertion leftOperand = this.leftOperand();
        return leftOperand.getAssertion(PropertyAssertion.class, ASTOperandProperty.class, "LEFT OPERAND PROPERTY");
    }

    public PropertyAssertion leftProperty(String path) throws Exception {
        return this.leftProperty().hasPath(path);
    }

    public StaticStringAssertion leftString() throws Exception {
        OperandAssertion leftOperand = this.leftOperand();
        return leftOperand.getAssertion(StaticStringAssertion.class, ASTOperandStaticString.class, "LEFT OPERAND STRING");
    }

    public StaticStringAssertion leftString(String string) throws Exception {
        return this.leftString().hasValue(string);
    }

    public StaticNumberAssertion leftNumber() throws Exception {
        OperandAssertion leftOperand = this.leftOperand();
        return leftOperand.getAssertion(StaticNumberAssertion.class, ASTOperandStaticNumber.class, "LEFT OPERAND NUMBER");
    }

    public StaticBoolAssertion leftBoolean() throws Exception {
        OperandAssertion leftOperand = this.leftOperand();
        this.shouldEquals(((ASTCondition)this.model).getLeftOperand().getDataType(), DataPropertyType.Boolean, "LEFT OPERAND BOOLEAN");
        return leftOperand.getAssertion(StaticBoolAssertion.class, ASTOperandStatic.class, "LEFT OPERAND BOOLEAN");
    }

    public StaticBoolAssertion leftBoolean(boolean boolVal) throws Exception {
        return this.leftBoolean().hasValue(boolVal);
    }

    public VariableReferenceAssertion leftVariable() throws Exception {
        OperandAssertion leftOperand = this.leftOperand();
        return leftOperand.getAssertion(VariableReferenceAssertion.class, ASTOperandVariable.class, "LEFT OPERAND VARIABLE");
    }

    public VariableReferenceAssertion leftVariable(String name) throws Exception {
        return this.leftVariable().hasName(name);
    }

    public OperandArithmeticalAssertion leftArithmetical() throws Exception {
        OperandAssertion leftOperand = this.leftOperand();
        return leftOperand.getAssertion(OperandArithmeticalAssertion.class, ASTOperandArithmetical.class, "LEFT OPERAND ARITHMETICAL");
    }

    public ASTArithmeticalOperationAssertion leftArithmeticalOperation() throws Exception {
        return this.leftArithmetical().operation();
    }

    public ConditionAssertion leftSubCondition() throws Exception {
        OperandAssertion leftOperand = this.leftOperand();
        return leftOperand.getAssertion(ConditionAssertion.class, ASTCondition.class, "LEFT OPERAND CONDITION");
    }

    public ConditionAssertion leftSubConditionGroup() throws Exception {
        OperandAssertion leftOperand = this.leftOperand();
        return leftOperand.getAssertion(ConditionAssertion.class, ASTCondition.class, "LEFT OPERAND CONDITION GROUP");
    }

    public ArrayAssertion leftArray() throws Exception {
        OperandAssertion leftOperand = this.leftOperand();
        return leftOperand.getAssertion(ArrayAssertion.class, ASTOperandArray.class, "LEFT OPERAND ARRAY");
    }

    public FunctionAssertion rightFunction() throws Exception {
        OperandAssertion rigthOperand = this.rightOperand();
        return rigthOperand.getAssertion(FunctionAssertion.class, ASTOperandFunction.class, "RIGHT OPERAND FUNCTION");
    }

    public PropertyAssertion rightProperty() throws Exception {
        OperandAssertion rightOperand = this.rightOperand();
        return rightOperand.getAssertion(PropertyAssertion.class, ASTOperandProperty.class, "RIGHT OPERAND PROPERTY");
    }

    public StaticStringAssertion rightString() throws Exception {
        OperandAssertion rightOperand = this.rightOperand();
        return rightOperand.getAssertion(StaticStringAssertion.class, ASTOperandStaticString.class, "RIGHT OPERAND STRING");
    }

    public StaticStringAssertion rightString(String string) throws Exception {
        return this.rightString().hasValue(string);
    }

    public StaticNumberAssertion rightNumber() throws Exception {
        OperandAssertion rightOperand = this.rightOperand();
        return rightOperand.getAssertion(StaticNumberAssertion.class, ASTOperandStaticNumber.class, "RIGHT OPERAND NUMBER");
    }

    public StaticNumberAssertion rightNumber(Double value) throws Exception {
        return this.rightNumber().hasValue(value);
    }

    public StaticBoolAssertion rightBoolean(boolean expected) throws Exception {
        return this.rightBoolean().hasValue(expected);
    }

    public StaticBoolAssertion rightBoolean() throws Exception {
        OperandAssertion rightOperand = this.rightOperand();
        this.shouldEquals(((ASTOperandBase)rightOperand.model).getDataType(), DataPropertyType.Boolean, "RIGHT OPERAND BOOLEAN");
        return rightOperand.getAssertion(StaticBoolAssertion.class, ASTOperandStatic.class, "RIGHT OPERAND BOOLEAN");
    }

    public VariableReferenceAssertion rightVariable() throws Exception {
        OperandAssertion rightOperand = this.rightOperand();
        return rightOperand.getAssertion(VariableReferenceAssertion.class, ASTOperandVariable.class, "RIGHT OPERAND VARIABLE");
    }

    public VariableReferenceAssertion rightVariable(String name) throws Exception {
        return this.rightVariable().hasName(name);
    }

    public OperandArithmeticalAssertion rightArithmetical() throws Exception {
        OperandAssertion rightOperand = this.rightOperand();
        return rightOperand.getAssertion(OperandArithmeticalAssertion.class, ASTOperandArithmetical.class, "RIGHT OPERAND ARITHMETICAL");
    }

    public ASTArithmeticalOperationAssertion rightArithmeticalOperation() throws Exception {
        return this.rightArithmetical().operation();
    }

    public ConditionAssertion rightSubCondition() throws Exception {
        OperandAssertion rightOperand = this.leftOperand();
        return rightOperand.getAssertion(ConditionAssertion.class, ASTCondition.class, "RIGHT OPERAND CONDITION");
    }

    public ConditionAssertion rightSubConditionGroup() throws Exception {
        OperandAssertion rightOperand = this.rightOperand();
        return rightOperand.getAssertion(ConditionAssertion.class, ASTCondition.class, "RIGHT OPERAND CONDITION GROUP");
    }

    public ArrayAssertion rightArray() throws Exception {
        OperandAssertion operand = this.rightOperand();
        return operand.getAssertion(ArrayAssertion.class, ASTOperandArray.class, "RIGHT OPERAND ARRAY");
    }

    @Override
    public ConditionAssertion hasConnector(ASTConditionConnector connector) {
        return (ConditionAssertion)super.hasConnector(connector);
    }

    public ConditionAssertion hasNoConnector() {
        this.shouldBeNull((Object)((ASTCondition)this.model).getConnector(), "CONNECTOR");
        return this;
    }

    public RuleAssertion parentRule() {
        this.shouldBeInstanceOf(this.parent(), RuleAssertion.class, "PARENT RULE");
        return (RuleAssertion)this.parent();
    }

    public ConditionGroupAssertion parentConditionGroup() {
        this.shouldBeInstanceOf(this.parent(), ConditionGroupAssertion.class, "PARENT CONDITION GROUP");
        return (ConditionGroupAssertion)this.parent();
    }

    public RuleListAssertion parentRuleList() {
        RuleAssertion rule = this.parentRule();
        this.shouldBeInstanceOf(rule.parent(), RuleListAssertion.class, "PARENT RULE LIST");
        return (RuleListAssertion)rule.parent();
    }

    @Override
    public ModelRootAssertion parentModel() {
        RuleListAssertion rule = this.parentRuleList();
        this.shouldBeInstanceOf(rule.parent(), ModelRootAssertion.class, "PARENT ROOT");
        return (ModelRootAssertion)rule.parent();
    }

    public VariableAssertion parentVariable() {
        this.shouldBeInstanceOf(this.parent(), VariableAssertion.class, "PARENT VARIABLE");
        return (VariableAssertion)this.parent;
    }

    public LambdaAssertion parentLambda() {
        this.shouldBeInstanceOf(this.parent(), LambdaAssertion.class, "PARENT LAMBDA");
        return (LambdaAssertion)this.parent;
    }

    public FunctionAssertion parentFunction() {
        return this.parentLambda().parentFunction();
    }

    public ConditionAssertion hasNoRightOperand() {
        this.shouldBeNull(((ASTCondition)this.model).getRightOperand(), "RIGHT OPERAND");
        return this;
    }
}

