/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.unittesting.astassertion;

import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.ast.operand.ASTOperandBase;
import io.openvalidation.common.ast.operand.ASTOperandFunction;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.unittesting.astassertion.ASTAssertionBase;
import io.openvalidation.common.unittesting.astassertion.ASTItemAssertionBase;
import io.openvalidation.common.unittesting.astassertion.LambdaAssertion;
import io.openvalidation.common.unittesting.astassertion.OperandAssertion;
import io.openvalidation.common.unittesting.astassertion.PropertyAssertion;
import io.openvalidation.common.unittesting.astassertion.VariableReferenceAssertion;
import io.openvalidation.common.unittesting.astassertion.lists.OperandListAssertion;

public class FunctionAssertion
extends ASTItemAssertionBase<ASTOperandFunction, ASTAssertionBase, FunctionAssertion> {
    OperandListAssertion parameters = null;

    public FunctionAssertion(ASTOperandFunction item, ASTModel ast, ASTAssertionBase parent) {
        super(item, ast, parent);
        this.parameters = new OperandListAssertion("FUNCTION " + item.getName() + " ", ast, this);
        this.parameters.fillList(item.getParameters(), p -> new OperandAssertion((ASTOperandBase)p, ast, this.parameters));
    }

    public FunctionAssertion hasName(String name) {
        this.shouldNotBeNull(this.model, "FUNCTION");
        this.shouldNotBeEmpty(((ASTOperandFunction)this.model).getName(), "FUNCTION NAME");
        this.shouldEquals(((ASTOperandFunction)this.model).getName(), name, "FUNCTION NAME");
        return this;
    }

    public FunctionAssertion hasType(DataPropertyType expectedType) {
        this.shouldEquals(((ASTOperandFunction)this.model).getDataType(), expectedType, "DataType");
        return this;
    }

    public FunctionAssertion hasArrayContentType(DataPropertyType expectedType) {
        this.shouldEquals(((ASTOperandFunction)this.model).getArrayContentType(), expectedType, "FUNCTION ARRAY CONTENT DATA TYPE");
        return this;
    }

    public FunctionAssertion sizeOfParameters(int size) {
        this.shouldHaveSizeOf(((ASTOperandFunction)this.model).getParameters(), size, "PARAMETERS");
        return this;
    }

    public OperandListAssertion parameters() {
        return this.parameters;
    }

    public PropertyAssertion firstProperty(String path) throws Exception {
        return this.firstProperty().hasPath(path);
    }

    public PropertyAssertion firstProperty() throws Exception {
        return ((OperandAssertion)this.parameters().first()).property();
    }

    public FunctionAssertion firstFunction() throws Exception {
        this.shouldHaveMinSizeOf(((ASTOperandFunction)this.model).getParameters(), 1, "PARAMETERS");
        OperandAssertion operand = new OperandAssertion(((ASTOperandFunction)this.model).getParameters().get(0), this.ast, this);
        return operand.function();
    }

    public FunctionAssertion firstArrayOfFunction() throws Exception {
        return this.firstFunction("GET_ARRAY_OF");
    }

    public FunctionAssertion firstWhereFunction() throws Exception {
        return this.firstFunction("WHERE");
    }

    public FunctionAssertion firstFunction(String name) throws Exception {
        FunctionAssertion function = this.firstFunction();
        return function.hasName(name);
    }

    public VariableReferenceAssertion firstVariable() throws Exception {
        return ((OperandAssertion)this.parameters().first()).variable();
    }

    public PropertyAssertion secondPropertyLambda(String path) throws Exception {
        return this.secondLambda().property().hasPath(path);
    }

    public PropertyAssertion secondProperty() throws Exception {
        return ((OperandAssertion)this.parameters().second()).property();
    }

    public LambdaAssertion secondLambda() throws Exception {
        return ((OperandAssertion)this.parameters().second()).lambda();
    }

    public VariableReferenceAssertion secondVariable() throws Exception {
        return ((OperandAssertion)this.parameters().second()).variable();
    }

    public FunctionAssertion parentFunction() {
        return this.parentOperand().parentFunction();
    }
}

