/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.unittesting.astassertion;

import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.ast.operand.property.ASTPropertyStaticPart;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.unittesting.astassertion.ASTAssertionBase;
import io.openvalidation.common.unittesting.astassertion.ASTItemAssertionBase;
import io.openvalidation.common.unittesting.astassertion.ConditionAssertion;
import io.openvalidation.common.unittesting.astassertion.ConditionGroupAssertion;
import io.openvalidation.common.unittesting.astassertion.FunctionAssertion;
import io.openvalidation.common.unittesting.astassertion.ModelRootAssertion;
import io.openvalidation.common.unittesting.astassertion.OperandAssertion;
import io.openvalidation.common.unittesting.astassertion.PropertyStaticPartAssertion;
import io.openvalidation.common.unittesting.astassertion.VariableAssertion;
import io.openvalidation.common.unittesting.astassertion.lists.OperandListAssertion;
import java.util.List;
import java.util.stream.Collectors;

public class PropertyAssertion
extends ASTItemAssertionBase<ASTOperandProperty, ASTAssertionBase, PropertyAssertion> {
    public PropertyAssertion(ASTOperandProperty item, ASTModel ast, ASTAssertionBase parent) {
        super(item, ast, parent);
    }

    public PropertyAssertion hasPath(String path) {
        this.shouldNotBeEmpty();
        this.shouldEquals(((ASTOperandProperty)this.model).getPathAsString(), path, "PROPERTY PATH");
        return this;
    }

    public PropertyAssertion hasEmptyPath() {
        return this.hasPath("");
    }

    public PropertyAssertion hasLambdaToken(String token) {
        this.shouldNotBeEmpty();
        this.shouldEquals(((ASTOperandProperty)this.model).getLambdaToken(), token, "PROPERTY LAMBDA");
        return this;
    }

    public PropertyAssertion hasSameLambdaTokenAsParentLambdaCondition() {
        this.parentOperand().parentCondition();
        this.shouldNotBeEmpty(((ASTOperandProperty)this.model).getLambdaToken(), "PROPERTY LAMBDA TOKEN");
        ((OperandAssertion)this.parent).parentCondition().parentLambda().hasToken(((ASTOperandProperty)this.model).getLambdaToken());
        return this;
    }

    public PropertyAssertion tokenStartsWith(String expectedStart) {
        this.shouldNotBeEmpty();
        this.shouldNotBeEmpty(((ASTOperandProperty)this.model).getLambdaToken(), "PROPERTY LAMBDA TOKEN");
        this.shouldStartsWith(((ASTOperandProperty)this.model).getLambdaToken(), expectedStart, "PROPERTY LAMBDA TOKEN");
        return this;
    }

    public PropertyAssertion hasType(DataPropertyType type) {
        this.shouldNotBeEmpty();
        this.shouldEquals(((ASTOperandProperty)this.model).getDataType(), type, "DATA PROPERTY TYPE");
        return this;
    }

    public PropertyAssertion hasArrayContentType(DataPropertyType type) {
        this.shouldNotBeEmpty();
        this.shouldEquals(((ASTOperandProperty)this.model).getArrayContentType(), type, "ARRAY PROPERTY CONTENT TYPE");
        return this;
    }

    @Override
    public OperandAssertion parentOperand() {
        this.shouldBeInstanceOf(this.parent(), OperandAssertion.class, "PARENT OPERAND");
        return (OperandAssertion)this.parent();
    }

    public VariableAssertion parentVariable() {
        return this.parentOperand().parentVariable();
    }

    public FunctionAssertion parentFunction() {
        return this.parentOperand().parentList().parentFunction();
    }

    @Override
    public ConditionAssertion parentCondition() {
        return this.parentOperand().parentCondition();
    }

    public ConditionGroupAssertion parentConditionGroup() {
        return this.parentCondition().parentConditionGroup();
    }

    @Override
    public ModelRootAssertion parentModel() {
        if (this.parent() instanceof VariableAssertion) {
            return ((VariableAssertion)this.parent()).parentModel();
        }
        return this.parentCondition().parentModel();
    }

    public PropertyStaticPartAssertion staticPart(int index) {
        List parts = ((ASTOperandProperty)this.model).getPath().stream().filter(p -> p instanceof ASTPropertyStaticPart).map(p -> (ASTPropertyStaticPart)p).collect(Collectors.toList());
        this.shouldHaveMinSizeOf(parts, index + 1, "PROPERTY PART LIST SIZE");
        this.shouldBeInstanceOf(((ASTOperandProperty)this.model).getPath().get(index), ASTPropertyStaticPart.class, "PROPERTY STATIC PART");
        return new PropertyStaticPartAssertion((ASTPropertyStaticPart)((ASTOperandProperty)this.model).getPath().get(index), this.ast, this);
    }

    public PropertyStaticPartAssertion firstStaticPart() {
        return this.staticPart(0);
    }

    public PropertyStaticPartAssertion secondStaticPart() {
        return this.staticPart(1);
    }

    public PropertyStaticPartAssertion thirdStaticPart() {
        return this.staticPart(2);
    }

    @Override
    protected String getIdentifier() {
        return this.model != null ? ((ASTOperandProperty)this.model).getPathAsString() : null;
    }

    public OperandListAssertion parentList() {
        ASTAssertionBase p = this.parent;
        if (p instanceof OperandAssertion) {
            p = ((OperandAssertion)this.parent).parentList();
        }
        this.shouldBeInstanceOf(p, OperandListAssertion.class, "PARENT OPERAND LIST");
        return (OperandListAssertion)p;
    }
}

