/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.unittesting.astassertion;

import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.common.model.OpenValidationResult;
import io.openvalidation.common.unittesting.astassertion.ASTAssertionBase;
import io.openvalidation.common.unittesting.astassertion.ASTValidationAssertion;
import io.openvalidation.common.unittesting.astassertion.ModelRootAssertion;
import io.openvalidation.common.utils.LINQ;
import io.openvalidation.common.utils.StringUtils;

public class ResultAssertion
extends ASTAssertionBase<ModelRootAssertion> {
    private OpenValidationResult result;
    private ModelRootAssertion _modelRootAssertion;

    public ResultAssertion(OpenValidationResult result) {
        super("RESULT", result.getASTModel(), null);
        this.result = result;
    }

    public ResultAssertion hasErrors() {
        this.shouldNotBeEmpty(this.result, "RESULT");
        this.shouldBeTrue(this.result.hasErrors(), "HAS ERRORS");
        return this;
    }

    public ASTValidationAssertion containsValidationMessage(String error) {
        ASTValidationException exception = LINQ.findFirst(this.result.getValidationErros(), e -> e.getUserMessage() != null && e.getUserMessage().contains(error));
        if (exception == null) {
            this.writeExpectedAndActual("VALIDATION MESSAGE  : " + error, "VALIDATION MESSAGES : " + StringUtils.join(this.result.getAllErrorMessages(), "\n                      "));
        }
        return new ASTValidationAssertion("VALIDATION EXCEPTION", exception, this);
    }

    public ResultAssertion containsErrorMessage(String error) {
        boolean hasMessage = LINQ.any(this.result.getErrors(), e -> e.getUserMessage() != null && e.getUserMessage().contains(error));
        if (!hasMessage) {
            this.writeExpectedAndActual("ERROR MESSAGE  : '" + error + "'", "ERROR MESSAGES -> \n\n" + StringUtils.join(this.result.getAllErrorMessages(), "\n"));
        }
        return this;
    }

    public static ResultAssertion assertResult(OpenValidationResult result) throws Exception {
        ResultAssertion asr = new ResultAssertion(result);
        asr.shouldNotBeNull(result, "RESULT");
        return asr;
    }
}

