/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.unittesting.astassertion;

import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.ast.operand.ASTOperandStatic;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.unittesting.astassertion.ASTAssertionBase;
import io.openvalidation.common.unittesting.astassertion.ASTItemAssertionBase;
import io.openvalidation.common.unittesting.astassertion.VariableReferenceAssertion;

public class StaticBoolAssertion
extends ASTItemAssertionBase<ASTOperandStatic, ASTAssertionBase, VariableReferenceAssertion> {
    private boolean _value;

    public StaticBoolAssertion(ASTOperandStatic item, ASTModel ast, ASTAssertionBase parent) {
        super(item, ast, parent);
        this.shouldEquals(item.getDataType(), DataPropertyType.Boolean, "STATIC BOOLEAN");
        this._value = Boolean.parseBoolean(item.getValue());
    }

    public StaticBoolAssertion hasValue(boolean expected) {
        this.shouldEquals(this._value, expected, "STATIC BOOLEAN");
        return this;
    }

    public StaticBoolAssertion isTrue() {
        this.shouldEquals(this._value, true, "STATIC BOOLEAN");
        return this;
    }

    public StaticBoolAssertion isFalse() {
        this.shouldEquals(this._value, false, "STATIC BOOLEAN");
        return this;
    }
}

