/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.unittesting.astassertion;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.ast.ASTVariable;
import io.openvalidation.common.ast.condition.ASTCondition;
import io.openvalidation.common.ast.condition.ASTConditionGroup;
import io.openvalidation.common.ast.operand.ASTOperandFunction;
import io.openvalidation.common.ast.operand.ASTOperandStaticNumber;
import io.openvalidation.common.ast.operand.ASTOperandStaticString;
import io.openvalidation.common.ast.operand.ASTOperandVariable;
import io.openvalidation.common.ast.operand.arithmetical.ASTOperandArithmetical;
import io.openvalidation.common.ast.operand.property.ASTOperandProperty;
import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.unittesting.astassertion.ASTArithmeticalOperationAssertion;
import io.openvalidation.common.unittesting.astassertion.ASTAssertionBase;
import io.openvalidation.common.unittesting.astassertion.ASTItemAssertionBase;
import io.openvalidation.common.unittesting.astassertion.ConditionAssertion;
import io.openvalidation.common.unittesting.astassertion.ConditionGroupAssertion;
import io.openvalidation.common.unittesting.astassertion.FunctionAssertion;
import io.openvalidation.common.unittesting.astassertion.ModelRootAssertion;
import io.openvalidation.common.unittesting.astassertion.OperandArithmeticalAssertion;
import io.openvalidation.common.unittesting.astassertion.PropertyAssertion;
import io.openvalidation.common.unittesting.astassertion.StaticNumberAssertion;
import io.openvalidation.common.unittesting.astassertion.StaticStringAssertion;
import io.openvalidation.common.unittesting.astassertion.VariableReferenceAssertion;
import io.openvalidation.common.unittesting.astassertion.lists.VariableListAssertion;
import java.lang.reflect.Constructor;

public class VariableAssertion
extends ASTItemAssertionBase<ASTVariable, ASTAssertionBase, VariableAssertion> {
    public VariableAssertion(ASTVariable item, ASTModel ast, ASTAssertionBase parent) {
        super(item, 0, ast, parent);
    }

    public VariableAssertion(ASTVariable item, int index, ASTModel ast, ASTAssertionBase parent) {
        super(item, index, ast, parent);
    }

    @Override
    public VariableAssertion shouldNotBeEmpty() {
        super.shouldNotBeEmpty();
        this.shouldNotBeEmpty(((ASTVariable)this.model).getName(), "Name");
        this.shouldNotBeEmpty(((ASTVariable)this.model).getValue(), "Value");
        return this;
    }

    public VariableAssertion shouldBeEmpty() {
        super.shouldNotBeEmpty();
        this.shouldNotBeEmpty(((ASTVariable)this.model).getName(), "Name");
        this.shouldBeNull(((ASTVariable)this.model).getValue(), "Value");
        return this;
    }

    public VariableAssertion hasName(String name) {
        this.shouldNotBeEmpty();
        this.shouldEquals(((ASTVariable)this.model).getName(), name, "Name");
        return this;
    }

    public VariableAssertion hasCodeSafeName(String name) {
        this.shouldNotBeEmpty();
        this.shouldEquals(((ASTVariable)this.model).getCodeSafeName(), name, "Codesafe Name");
        return this;
    }

    public VariableReferenceAssertion variable() throws Exception {
        return this.getAssertion(VariableReferenceAssertion.class, ASTOperandVariable.class);
    }

    public StaticStringAssertion string() throws Exception {
        return this.getAssertion(StaticStringAssertion.class, ASTOperandStaticString.class);
    }

    public VariableAssertion hasString(String value) throws Exception {
        this.string().hasValue(value);
        return this;
    }

    public StaticNumberAssertion number() throws Exception {
        return this.getAssertion(StaticNumberAssertion.class, ASTOperandStaticNumber.class);
    }

    public VariableAssertion hasNumber(Double value) throws Exception {
        this.number().hasValue(value);
        return this;
    }

    public VariableAssertion hasType(DataPropertyType type) {
        this.shouldNotBeEmpty();
        this.shouldEquals(((ASTVariable)this.model).getDataType(), type, "DATA VARIABLE TYPE");
        return this;
    }

    public PropertyAssertion operandProperty() throws Exception {
        return this.getAssertion(PropertyAssertion.class, ASTOperandProperty.class);
    }

    public VariableReferenceAssertion operandVariable() throws Exception {
        return this.getAssertion(VariableReferenceAssertion.class, ASTOperandVariable.class);
    }

    public FunctionAssertion operandWhereFunction() throws Exception {
        return this.operandFunction().hasName("WHERE");
    }

    public FunctionAssertion operandFunction() throws Exception {
        return this.getAssertion(FunctionAssertion.class, ASTOperandFunction.class);
    }

    public OperandArithmeticalAssertion arithmetic() throws Exception {
        return this.getAssertion(OperandArithmeticalAssertion.class, ASTOperandArithmetical.class);
    }

    public ASTArithmeticalOperationAssertion arithmeticalOperation() throws Exception {
        return this.arithmetic().operation();
    }

    public ConditionAssertion condition() throws Exception {
        return this.getAssertion(ConditionAssertion.class, ASTCondition.class);
    }

    public ConditionGroupAssertion conditionGroup() throws Exception {
        return this.getAssertion(ConditionGroupAssertion.class, ASTConditionGroup.class);
    }

    public FunctionAssertion function() throws Exception {
        return this.getAssertion(FunctionAssertion.class, ASTOperandFunction.class);
    }

    public FunctionAssertion function(String name) throws Exception {
        FunctionAssertion function = this.function();
        return function.hasName(name);
    }

    private <S extends ASTAssertionBase, T extends ASTItem> S getAssertion(Class<S> assrt, Class<T> itemcls) throws Exception {
        this.shouldNotBeEmpty();
        this.shouldBeInstanceOf(((ASTVariable)this.model).getValue(), itemcls, "VALUE");
        for (Constructor<?> constructor : assrt.getDeclaredConstructors()) {
            try {
                return (S)((ASTAssertionBase)constructor.newInstance(((ASTVariable)this.model).getValue(), this.ast, this));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new IllegalArgumentException("No constructor with matching signature found.");
    }

    public VariableListAssertion parentList() {
        this.shouldBeInstanceOf(this.parent(), VariableListAssertion.class, "PARENT VARIABLES");
        return (VariableListAssertion)this.parent();
    }

    @Override
    public ModelRootAssertion parentModel() {
        return this.parentList().parentRoot();
    }
}

