/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.utils;

import io.openvalidation.common.utils.StringUtils;

public class Console {
    private static boolean hasANSI = false;

    public static void error(String error) throws Exception {
        Console.print("\u001b[1;31m" + error + "\u001b[0m");
    }

    public static void success(String error) throws Exception {
        Console.print("\u001b[1;32m" + error + "\u001b[0m");
    }

    public static String getTitleStart(String text) {
        return "\n\n\u001b[0;37m" + text + " " + "\u2b9f" + " \n\n" + "\u001b[0m";
    }

    public static void titleStart(String text) {
        Console.print(Console.getTitleStart(text));
    }

    public static void titleEnd(String text) {
        Console.print("\n\n\u001b[0;37m" + text + " " + "\u2b9d" + " \n\n" + "\u001b[0m");
    }

    public static void print(String msg) {
        System.out.print(msg != null ? msg.replace("\r\n", "\n").replace("\r", "\\r") : "");
    }

    public static void printl(String msg) {
        System.out.print(msg + "\n");
    }

    public static void printlGray(String msg) {
        System.out.print(Console.grayString(msg) + "\n");
    }

    public static String errorString(String value) {
        return "\u001b[0;31m" + value + "\u001b[0m";
    }

    public static String successString(String value) {
        return "\u001b[0;32m" + value + "\u001b[0m";
    }

    public static String grayString(String value) {
        return "\u001b[0;37m" + value + "\u001b[0m";
    }

    public static void printError(Exception exp) {
        if (exp != null) {
            Console.printl(exp.toString() + "\n\n");
            Console.printl(exp.getMessage());
            Console.printl(StringUtils.join(exp.getStackTrace(), "\n", e -> e.toString()));
        }
    }
}

