/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.utils;

import io.openvalidation.common.model.ContentOptionKind;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class FileSystemUtils {
    public static final String NewLine = "\\n|\\r\\n";

    public static String readFile(String filePath) throws IOException {
        StringBuilder contentBuilder = new StringBuilder();
        Stream<String> stream = Files.lines(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8);
        stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        return contentBuilder.toString();
    }

    public static String readFileFromURL(String url) throws Exception {
        String inputLine;
        URL oracle = new URL(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(oracle.openStream()));
        String out = "";
        while ((inputLine = in.readLine()) != null) {
            out = out + inputLine;
        }
        in.close();
        return out;
    }

    public static void writeFile(String filePath, String content) throws Exception {
        File f = new File(filePath);
        FileUtils.writeStringToFile((File)f, (String)content, (String)"UTF-8");
    }

    public static void fileShouldExists(String filePath, String error) throws FileNotFoundException {
        if (!FileSystemUtils.fileExists(filePath)) {
            throw new FileNotFoundException(error);
        }
    }

    public static boolean fileExists(String filePath) {
        File f = new File(filePath);
        return f.exists() && !f.isDirectory();
    }

    public static boolean isDirectory(String filePath) {
        return !FileSystemUtils.isFile(filePath);
    }

    public static boolean isFile(String filePath) {
        String extension = FilenameUtils.getExtension((String)filePath);
        return extension == null || !extension.isEmpty();
    }

    public static boolean isLocalFile(String filePath) {
        if (filePath == null) {
            return false;
        }
        if (filePath.startsWith("file:///")) {
            return true;
        }
        String extension = FilenameUtils.getExtension((String)filePath.trim());
        boolean hasExtension = extension == null || !extension.trim().isEmpty();
        boolean isUrl = filePath.contains("://");
        boolean hasNewLines = filePath.contains("\n");
        boolean hasSpace = extension.contains(" ");
        return hasExtension && !isUrl && !hasNewLines && !hasSpace && !filePath.contains("{");
    }

    public static boolean isURL(String filePath) {
        if (filePath == null) {
            return false;
        }
        return filePath.contains("://") && !filePath.contains("file://") && !filePath.contains("{");
    }

    public static String getDirectory(String filePath) {
        Path p = Paths.get(filePath, new String[0]);
        if (p != null && p.getParent() != null) {
            return p.getParent().toString();
        }
        return null;
    }

    public static String getWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    public static String getExecutingDirectory() {
        String path = new File(".").getAbsolutePath();
        return path.endsWith(".") ? path.substring(0, path.length() - 1) : path;
    }

    public static void deleteFile(String file) throws Exception {
        FileUtils.forceDelete((File)new File(file));
    }

    public static ContentOptionKind getContentKind(String value) {
        if (FileSystemUtils.isURL(value)) {
            return ContentOptionKind.URL;
        }
        if (FileSystemUtils.isLocalFile(value)) {
            return ContentOptionKind.FilePath;
        }
        return ContentOptionKind.Content;
    }

    public static String getFileNameWithoutExtension(String filePathOrURL) {
        return FilenameUtils.getBaseName((String)filePathOrURL);
    }

    public static String combinePath(String first, String ... more) {
        return Paths.get(first, more).toString();
    }

    public static List<String> getFilesFromDirectory(String dirname, String filterExt, boolean recursive) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        Files.find(Paths.get(dirname, new String[0]), Integer.MAX_VALUE, (filePath, fileAttr) -> (recursive ? fileAttr.isRegularFile() : !fileAttr.isDirectory()) && filePath.toAbsolutePath().toString().endsWith("." + filterExt), new FileVisitOption[0]).forEach(f -> files.add(f.toAbsolutePath().toString()));
        return files;
    }
}

