/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class GenericsUtils {
    public static String getGenericTypeName(Class<?> cls) {
        return GenericsUtils.getGenericTypeName(cls, 0);
    }

    public static String getGenericTypeName(Class<?> cls, int position) {
        Type type = GenericsUtils.getGenericType(cls, position);
        return type != null ? type.getTypeName() : null;
    }

    public static Type getGenericType(Class<?> cls, int position) {
        ParameterizedType type;
        if (cls.getGenericSuperclass() != null && cls.getGenericSuperclass() instanceof ParameterizedType && (type = (ParameterizedType)cls.getGenericSuperclass()) != null && type.getActualTypeArguments() != null && type.getActualTypeArguments().length > position) {
            return type.getActualTypeArguments()[position];
        }
        return null;
    }

    public static <T> Class<T> getGenericClass(Class<?> cls, int position) {
        Type type = GenericsUtils.getGenericType(cls, position);
        return type != null ? (Class)type : null;
    }

    public static <T> T cast(Object obj, Class<T> cls) {
        return (T)(obj != null && cls.isInstance(obj) ? obj : null);
    }
}

