/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.utils;

import io.openvalidation.common.ast.condition.ASTConditionConnector;
import io.openvalidation.common.utils.NameMasking;

public class GrammarBuilder {
    private StringBuilder _builder = new StringBuilder();

    public GrammarBuilder with(String value) {
        this._builder.append(value);
        return this;
    }

    public GrammarBuilder with(Number value) {
        this._builder.append(value.toString());
        return this;
    }

    public GrammarBuilder AS() {
        return this.AS("AS", "");
    }

    public GrammarBuilder AS(String name) {
        return this.AS("AS", name);
    }

    public GrammarBuilder AS(String affixForToken, String name) {
        this._builder.append(" \u02acas\u02ac" + affixForToken + " ").append(name);
        return this;
    }

    public GrammarBuilder AS_OPERATOR() {
        return this.AS_OPERATOR("ASOPERATOR", "");
    }

    public GrammarBuilder AS_OPERATOR(String name) {
        return this.AS_OPERATOR("ASOPERATOR", name);
    }

    public GrammarBuilder AS_OPERATOR(String affixForToken, String name) {
        this._builder.append(" \u02acasoperator\u02ac" + affixForToken + " ").append(name);
        return this;
    }

    public GrammarBuilder TAKE() {
        return this.TAKE("TAKE", "");
    }

    public GrammarBuilder TAKE(String value) {
        return this.TAKE("TAKE", value);
    }

    public GrammarBuilder TAKE(String affixForToken, String value) {
        this._builder.append(" \u02actake\u02ac" + affixForToken + " ").append(value);
        return this;
    }

    public GrammarBuilder WITH() {
        return this.WITH("WITH", "");
    }

    public GrammarBuilder WITH(String value) {
        return this.WITH("WITH", value);
    }

    public GrammarBuilder WITH(String affixForToken, String value) {
        this._builder.append(" \u02acwith\u02ac" + affixForToken + " ").append(value);
        return this;
    }

    public GrammarBuilder ORDERBY() {
        return this.FIRST("ORDERBY", "");
    }

    public GrammarBuilder ORDERBY(String value) {
        return this.ORDERBY("ORDERBY", value);
    }

    public GrammarBuilder ORDERBY(String affixForToken, String value) {
        this._builder.append(" \u02acordered\u02ac" + affixForToken + " ").append(value);
        return this;
    }

    public GrammarBuilder FROM() {
        return this.FIRST("FROM", "");
    }

    public GrammarBuilder FROM(String value) {
        return this.FROM("FROM", value);
    }

    public GrammarBuilder FROM(String affixForToken, String value) {
        this._builder.append(" \u02acfrom\u02ac" + affixForToken + " ").append(value);
        return this;
    }

    public GrammarBuilder FIRST() {
        return this.FIRST("FIRST", "");
    }

    public GrammarBuilder FIRST(String value) {
        return this.FIRST("FIRST", value);
    }

    public GrammarBuilder FIRST(String affixForToken, String value) {
        this._builder.append(" \u02acfirst\u02ac" + affixForToken + " ").append(value);
        return this;
    }

    public GrammarBuilder LAST() {
        return this.LAST("LAST", "");
    }

    public GrammarBuilder LAST(String value) {
        return this.LAST("LAST", value);
    }

    public GrammarBuilder LAST(String affixForToken, String value) {
        this._builder.append(" \u02aclast\u02ac" + affixForToken + " ").append(value);
        return this;
    }

    public GrammarBuilder IF() {
        return this.IF("IF", "");
    }

    public GrammarBuilder IF(String value) {
        return this.IF("IF", value);
    }

    public GrammarBuilder IF(String affixForToken, String value) {
        this._builder.append("\u02acif\u02ac" + affixForToken + " ").append(value + " ");
        return this;
    }

    public GrammarBuilder THEN() {
        return this.THEN("THEN", "");
    }

    public GrammarBuilder THEN(String value) {
        return this.THEN("THEN", value);
    }

    public GrammarBuilder THEN(String affixForToken, String value) {
        this._builder.append(" \u02acthen\u02ac" + affixForToken + " ").append(value);
        return this;
    }

    public GrammarBuilder PARAGRAPH() {
        this._builder.append(" \u02acparagraph\u02ac");
        return this;
    }

    public GrammarBuilder EQ() {
        return this.EQ("EQUALS");
    }

    public GrammarBuilder EQ(String affixForToken) {
        return this.EQ(affixForToken, "", "");
    }

    public GrammarBuilder EQ(String left, String right) {
        return this.EQ("EQUALS", left, right);
    }

    public GrammarBuilder EQ(String affixForToken, String left, String right) {
        this._builder.append(left).append(" \u02acoperator\u02acequals\u02ac" + affixForToken + " ").append(right);
        return this;
    }

    public GrammarBuilder NEQ() {
        return this.NEQ("", "");
    }

    public GrammarBuilder NEQ(String left, String right) {
        return this.NEQ("NOT_EQUAL", left, right);
    }

    public GrammarBuilder NEQ(String affixForToken, String left, String right) {
        this._builder.append(left).append(" \u02acoperator\u02acnot_equals\u02ac" + affixForToken + " ").append(right);
        return this;
    }

    public String getText() {
        return this._builder.toString().trim();
    }

    public GrammarBuilder AND() {
        return this.AND("AND");
    }

    public GrammarBuilder AND(String affixForToken) {
        this._builder.append(" \u02acand\u02ac" + affixForToken + " ");
        return this;
    }

    public GrammarBuilder OR() {
        return this.OR("OR");
    }

    public GrammarBuilder OR(String affixForToken) {
        this._builder.append(" \u02acor\u02ac" + affixForToken + " ");
        return this;
    }

    public GrammarBuilder UNLESS() {
        return this.UNLESS("UNLESS");
    }

    public GrammarBuilder UNLESS(String affixForToken) {
        this._builder.append(" \u02acunless\u02ac" + affixForToken + " ");
        return this;
    }

    public GrammarBuilder EXISTS() {
        return this.EXISTS("EXISTS");
    }

    public GrammarBuilder EXISTS(String affixForToken) {
        this._builder.append(" \u02acoperator\u02acexists\u02ac" + affixForToken + " ");
        return this;
    }

    public GrammarBuilder NOT_EXISTS() {
        return this.NOT_EXISTS("NOT_EXISTS");
    }

    public GrammarBuilder NOT_EXISTS(String affixForToken) {
        this._builder.append(" \u02acoperator\u02acnot_exists\u02ac" + affixForToken + " ");
        return this;
    }

    public GrammarBuilder indentationDepth(int indentationLevel, ASTConditionConnector connector) {
        return this.indentationDepth(indentationLevel, connector, null);
    }

    public GrammarBuilder indentationDepth(int indentationLevel, ASTConditionConnector connector, String affixForConnector) {
        String trimmedContent = this._builder.toString().trim();
        this._builder = new StringBuilder(trimmedContent);
        this._builder.append("\n");
        for (int i = 0; i < indentationLevel; ++i) {
            this._builder.append(" ");
        }
        switch (connector) {
            case AND: {
                return affixForConnector != null ? this.AND(affixForConnector) : this.AND();
            }
            case OR: {
                return affixForConnector != null ? this.OR(affixForConnector) : this.OR();
            }
            case UNLESS: {
                return affixForConnector != null ? this.UNLESS(affixForConnector) : this.UNLESS();
            }
        }
        throw new RuntimeException("UNKNOWN CONNECTOR: " + affixForConnector);
    }

    public GrammarBuilder ERRORCODE(int errorCode) {
        return this.ERRORCODE("ERRORCODE", errorCode);
    }

    public GrammarBuilder ERRORCODE(String affixForToken, int errorCode) {
        this._builder.append(" \u02acerrorcode\u02ac" + affixForToken + " " + errorCode + " ");
        return this;
    }

    public GrammarBuilder VARIABLE(String content, String name) {
        return this.with(content + " ").AS(name);
    }

    public GrammarBuilder MUST() {
        return this.MUST("MUST");
    }

    public GrammarBuilder MUST(String affixForToken) {
        this._builder.append(" \u02acconstraint\u02acmust\u02ac" + affixForToken + " ");
        return this;
    }

    public GrammarBuilder MUST_NOT() {
        return this.MUST_NOT(NameMasking.maskName("MUST NOT"));
    }

    public GrammarBuilder MUST_NOT(String affixForToken) {
        this._builder.append(" \u02acconstraint\u02acmustnot\u02ac" + affixForToken + " ");
        return this;
    }

    public GrammarBuilder LESS_THAN() {
        return this.LESS_THAN("");
    }

    public GrammarBuilder LESS_THAN(int value) {
        return this.LESS_THAN("LESS_THAN", String.valueOf(value));
    }

    public GrammarBuilder LESS_THAN(String value) {
        return this.LESS_THAN("LESS_THAN", value);
    }

    public GrammarBuilder LESS_THAN(String affixForToken, String value) {
        this._builder.append(" \u02acoperator\u02acless_than\u02ac" + affixForToken + " " + value + " ");
        return this;
    }

    public GrammarBuilder GREATER_THAN() {
        return this.GREATER_THAN("");
    }

    public GrammarBuilder GREATER_THAN(int value) {
        return this.GREATER_THAN("GREATER_THAN", String.valueOf(value));
    }

    public GrammarBuilder GREATER_THAN(String value) {
        return this.GREATER_THAN("GREATER_THAN", value);
    }

    public GrammarBuilder GREATER_THAN(String affixForToken, String value) {
        this._builder.append(" \u02acoperator\u02acgreater_than\u02ac" + affixForToken + " " + value + " ");
        return this;
    }

    public GrammarBuilder GREATER_OR_EQUALS() {
        return this.GREATER_OR_EQUALS("");
    }

    public GrammarBuilder GREATER_OR_EQUALS(int value) {
        return this.GREATER_OR_EQUALS("GREATER_OR_EQUALS", String.valueOf(value));
    }

    public GrammarBuilder GREATER_OR_EQUALS(String value) {
        return this.GREATER_OR_EQUALS("GREATER_OR_EQUALS", value);
    }

    public GrammarBuilder GREATER_OR_EQUALS(String affixForToken, String value) {
        this._builder.append(" \u02acoperator\u02acgreater_or_equals\u02ac" + affixForToken + " " + value + " ");
        return this;
    }

    public GrammarBuilder AT_LEAST_ONE_OF() {
        return this.AT_LEAST_ONE_OF("");
    }

    public GrammarBuilder AT_LEAST_ONE_OF(String value) {
        return this.AT_LEAST_ONE_OF("ONE_OF", value);
    }

    public GrammarBuilder AT_LEAST_ONE_OF(String affixForToken, String value) {
        this._builder.append(" \u02acoperator\u02acat_least_one_of\u02ac" + affixForToken + " " + value + " ");
        return this;
    }

    public GrammarBuilder NONE_OF() {
        return this.NONE_OF("");
    }

    public GrammarBuilder NONE_OF(String value) {
        return this.NONE_OF("ONE_OF", value);
    }

    public GrammarBuilder NONE_OF(String affixForToken, String value) {
        this._builder.append(" \u02acoperator\u02acnone_of\u02ac" + affixForToken + " " + value + " ");
        return this;
    }

    public GrammarBuilder COMMENT() {
        return this.COMMENT(new String[0]);
    }

    public GrammarBuilder COMMENT(String ... comments) {
        this._builder.append("\u02accomment\u02acCOMMENT " + String.join((CharSequence)"\n", comments));
        return this;
    }

    public GrammarBuilder MULTIPLY() {
        return this.MULTIPLY("");
    }

    public GrammarBuilder MULTIPLY(Number value) {
        return this.MULTIPLY("MULTIPLY", String.valueOf(value));
    }

    public GrammarBuilder MULTIPLY(String value) {
        return this.MULTIPLY("MULTIPLY", value);
    }

    public GrammarBuilder MULTIPLY(String affixForToken, String value) {
        this._builder.append(" \u02acarithmoperator\u02acmultiply\u02ac" + affixForToken + " " + value);
        return this;
    }

    public GrammarBuilder ADD() {
        return this.ADD("");
    }

    public GrammarBuilder ADD(int i) {
        return this.ADD("PLUS", String.valueOf(i));
    }

    public GrammarBuilder ADD(String value) {
        return this.ADD("PLUS", value);
    }

    public GrammarBuilder ADD(String affixForToken, String value) {
        this._builder.append(" \u02acarithmoperator\u02acadd\u02ac" + affixForToken + " " + value);
        return this;
    }

    public GrammarBuilder MINUS() {
        return this.MINUS("");
    }

    public GrammarBuilder MINUS(int i) {
        return this.MINUS("MINUS", String.valueOf(i));
    }

    public GrammarBuilder MINUS(String value) {
        return this.MINUS("MINUS", value);
    }

    public GrammarBuilder MINUS(String affixForToken, String value) {
        this._builder.append(" \u02acarithmoperator\u02acsubtract\u02ac" + affixForToken + " " + value);
        return this;
    }

    public GrammarBuilder POWEROF() {
        return this.POWEROF("");
    }

    public GrammarBuilder POWEROF(int i) {
        return this.POWEROF("POWEROF", String.valueOf(i));
    }

    public GrammarBuilder POWEROF(String value) {
        return this.POWEROF("POWEROF", value);
    }

    public GrammarBuilder POWEROF(String affixForToken, String value) {
        this._builder.append(" \u02acarithmoperator\u02acpower\u02ac" + affixForToken + " " + value);
        return this;
    }

    public GrammarBuilder SUMOF() {
        return this.SUMOF("");
    }

    public GrammarBuilder SUMOF(String value) {
        return this.SUMOF("SUM_OF", value);
    }

    public GrammarBuilder SUMOF(String affixForToken, String value) {
        this._builder.append(" \u02acfunction\u02acsum_of\u02ac" + affixForToken + " " + value);
        return this;
    }

    public GrammarBuilder OF() {
        return this.OF("OF", "");
    }

    public GrammarBuilder OF(String entity) {
        return this.OF("OF", entity);
    }

    public GrammarBuilder OF(String affixForToken, String entity) {
        this._builder.append(" \u02acof\u02ac" + affixForToken + " " + entity + " ");
        return this;
    }

    public GrammarBuilder NL() {
        this._builder.append("\n");
        return this;
    }

    public GrammarBuilder CR() {
        this._builder.append("\r");
        return this;
    }

    public String toString() {
        return this.getText();
    }

    public static GrammarBuilder create() {
        return new GrammarBuilder();
    }

    public static GrammarBuilder createRule() {
        return new GrammarBuilder().IF();
    }

    public static GrammarBuilder createComment(String ... comments) {
        return new GrammarBuilder().COMMENT(comments);
    }

    public static GrammarBuilder createComment() {
        return new GrammarBuilder().COMMENT();
    }
}

