/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.utils;

import io.openvalidation.common.data.DataPropertyType;
import io.openvalidation.common.utils.NumberParsingUtils;
import io.openvalidation.common.utils.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonUtils {
    private static final Pattern jsonArrayPattern = Pattern.compile("\\[(.+,?)*]$");
    private static final Pattern jsonObjectPattern = Pattern.compile("\\{.*}$");

    public static void validate(String json, String schema) {
        JSONObject jsonData = JsonUtils.loadJson(json);
        JSONObject jsonSchema = JsonUtils.loadJson(schema);
        JsonUtils.validate(jsonData, jsonSchema);
    }

    public static void validate(JSONObject jsonData, JSONObject jsonSchema) {
        Schema sma = SchemaLoader.load((JSONObject)jsonData);
        sma.validate((Object)jsonData);
    }

    public static boolean isValid(String json, String schema) {
        return JsonUtils.isValid(JsonUtils.loadJson(json), JsonUtils.loadJson(schema));
    }

    public static boolean isValid(JSONObject jsonData, JSONObject jsonSchema) {
        try {
            JsonUtils.validate(jsonData, jsonSchema);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static JSONObject loadJson(String json) {
        if (!JsonUtils.isValidJsonFormat(json)) {
            return null;
        }
        return new JSONObject(new JSONTokener(StringUtils.toInputStream(json)));
    }

    public static Schema loadJsonSchema(String rawJson) {
        JSONObject json = JsonUtils.loadJson(rawJson);
        return SchemaLoader.load((JSONObject)json);
    }

    public static DataPropertyType parseType(Object object) {
        if (object instanceof Boolean) {
            return DataPropertyType.Boolean;
        }
        if (object instanceof Float) {
            return DataPropertyType.Decimal;
        }
        if (object instanceof Double) {
            return DataPropertyType.Decimal;
        }
        if (object instanceof Integer) {
            return DataPropertyType.Decimal;
        }
        if (object instanceof String) {
            return DataPropertyType.String;
        }
        if (object instanceof JSONArray) {
            return DataPropertyType.Array;
        }
        if (object instanceof JSONObject) {
            return DataPropertyType.Object;
        }
        return DataPropertyType.Unknown;
    }

    public static DataPropertyType parseArrayContentType(JSONArray jsonArray) {
        DataPropertyType type = DataPropertyType.Unknown;
        if (jsonArray.length() > 0) {
            String firstElementString = String.valueOf(jsonArray.get(0));
            type = JsonUtils.parseTypeFromString(firstElementString);
        }
        return type;
    }

    public static DataPropertyType parseTypeFromString(String firstElementString) {
        DataPropertyType type;
        if (NumberParsingUtils.isNumber(firstElementString)) {
            type = DataPropertyType.Decimal;
        } else if (StringUtils.isBoolean(firstElementString)) {
            type = DataPropertyType.Boolean;
        } else {
            Matcher jsonArrayMatcher = jsonArrayPattern.matcher(firstElementString);
            Matcher jsonObjectMatcher = jsonObjectPattern.matcher(firstElementString);
            type = jsonArrayMatcher.matches() ? DataPropertyType.Array : (jsonObjectMatcher.matches() ? DataPropertyType.Object : DataPropertyType.String);
        }
        return type;
    }

    public static DataPropertyType parseTypeBySchemaProperty(JSONObject schemaProperty) {
        String type;
        switch (type = schemaProperty != null && schemaProperty.has("type") ? schemaProperty.get("type") : "object") {
            case "boolean": {
                return DataPropertyType.Boolean;
            }
            case "integer": {
                return DataPropertyType.Decimal;
            }
            case "number": {
                return DataPropertyType.Decimal;
            }
            case "string": {
                return schemaProperty.has("enum") ? DataPropertyType.Enum : DataPropertyType.String;
            }
            case "date": {
                return DataPropertyType.Date;
            }
            case "array": {
                return DataPropertyType.Array;
            }
            case "object": {
                return DataPropertyType.Object;
            }
        }
        return DataPropertyType.Unknown;
    }

    public static String getSchemaAsString(JSONObject jsonObject) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (Object key : jsonObject.keySet()) {
            String keyStr = (String)key;
            Object value = jsonObject.get(keyStr);
            sb.append("key: " + keyStr + " value: " + value + "\n");
            if (!(value instanceof JSONObject)) continue;
            sb.append(JsonUtils.getSchemaAsString((JSONObject)value));
        }
        return sb.toString();
    }

    public static boolean isValidJsonFormat(String rawJson) {
        try {
            new JSONObject(rawJson);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(rawJson);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public static boolean isJsonData(String rawJson) {
        JSONObject json = JsonUtils.loadJson(rawJson);
        return json != null;
    }

    public static boolean isJsonSchema(String rawJson) {
        JSONObject json = JsonUtils.loadJson(rawJson);
        if (json != null) {
            return json.has("properties");
        }
        return false;
    }

    public static void combineProperties(JSONObject target, JSONObject source) {
        if (source == null || !source.has("properties") || source.getJSONObject("properties").keySet().size() < 1) {
            return;
        }
        if (target == null) {
            target = new JSONObject();
        }
        if (!target.has("properties")) {
            target.put("properties", (Object)new JSONObject());
        }
        JSONObject targetProperties = target.getJSONObject("properties");
        JSONObject sourceProperties = source.getJSONObject("properties");
        for (String key : sourceProperties.keySet()) {
            targetProperties.put(key, (Object)sourceProperties.getJSONObject(key));
        }
    }
}

