/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.utils;

import io.openvalidation.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class LINQ {
    public static <T> int count(List<T> list, Predicate<? super T> predicate) {
        List<T> lst = LINQ.where(list, predicate);
        return lst.size();
    }

    public static <T> List<T> where(T[] arr, Predicate<? super T> predicate) {
        if (arr != null) {
            return LINQ.where(Arrays.stream(arr).collect(Collectors.toList()), predicate);
        }
        return new ArrayList();
    }

    public static <T> List<T> where(List<T> list, Predicate<? super T> predicate) {
        if (list != null) {
            return list.stream().filter(predicate).collect(Collectors.toList());
        }
        return new ArrayList();
    }

    public static <T> boolean any(List<T> list, Predicate<? super T> predicate) {
        if (list != null) {
            return list.stream().anyMatch(predicate);
        }
        return false;
    }

    public static <T> T findFirst(List<T> list, Predicate<? super T> predicate) {
        Optional item;
        if (list != null && list.size() > 0 && (item = LINQ.where(list, predicate).stream().findFirst()) != null && item.isPresent()) {
            return (T)item.get();
        }
        return null;
    }

    public static <T, R> List<R> ofType(List<T> list, Class<R> cls) {
        if (list != null) {
            return list.stream().filter(e -> cls.isInstance(e)).map(e -> e).collect(Collectors.toList());
        }
        return new ArrayList();
    }

    public static <T> T findFirst(List<T> list) {
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static <T, R> List<R> select(T[] array, Function<? super T, ? extends R> mapper) {
        return LINQ.select(Arrays.stream(array).collect(Collectors.toList()), mapper);
    }

    public static <T, R> List<R> select(List<T> list, Function<? super T, ? extends R> mapper) {
        List<Object> files = new ArrayList();
        if (list != null) {
            files = list.stream().map(mapper).filter(i -> i != null).collect(Collectors.toList());
        }
        return files;
    }

    public static <T> List<T> toList(T ... array) {
        return Arrays.stream(array).collect(Collectors.toList());
    }

    public static <T> List<T> findDuplicates(List<T> collection) {
        HashSet uniques = new HashSet();
        return collection.stream().filter(e -> !uniques.add(e)).collect(Collectors.toList());
    }

    public static String[] array(String arrayPath) {
        ArrayList<String> lst = new ArrayList<String>();
        if (!StringUtils.isNullOrEmpty(arrayPath)) {
            lst.add(arrayPath);
        }
        return lst.toArray(new String[0]);
    }
}

