/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.utils;

import io.openvalidation.common.utils.StringUtils;
import java.text.StringCharacterIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameMasking {
    private static String hexEncodingMask = "_";

    public static String maskName(String name) {
        StringBuilder sb = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(name);
        char character = iterator.current();
        String commonCharPattern = "[a-zA-Z0-9]";
        while (character != '\uffff') {
            if (!String.valueOf(character).matches(commonCharPattern)) {
                sb.append(NameMasking.getMaskOf(Character.valueOf(character)));
            } else {
                sb.append(character);
            }
            character = iterator.next();
        }
        return sb.toString();
    }

    public static String getMaskOf(Character character) {
        String hex = Integer.toHexString(character.charValue());
        hex = hexEncodingMask + hex + hexEncodingMask;
        return hex;
    }

    public static String unmask(String maskedWord) {
        String input = maskedWord;
        String maskPattern = hexEncodingMask + "[a-zA-Z0-9]+" + hexEncodingMask;
        Pattern pattern = Pattern.compile(maskPattern);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            if (!input.contains(matcher.group())) continue;
            int hexContentStartIndex = input.indexOf(hexEncodingMask) + hexEncodingMask.length();
            int hexContentEndIndex = input.substring(hexContentStartIndex + 1).indexOf(hexEncodingMask) + hexContentStartIndex + 1;
            String hexCode = input.substring(hexContentStartIndex, hexContentEndIndex);
            int decimal = Integer.parseInt(hexCode, 16);
            String decodedHex = String.valueOf((char)decimal);
            input = input.replace(matcher.group(), decodedHex);
        }
        return input;
    }

    public static String maskVariableName(String varname) {
        if (!StringUtils.isNullOrEmpty(varname)) {
            return NameMasking.maskName(StringUtils.reverseKeywords(varname)) + "_var";
        }
        return varname;
    }

    public static String unmaskVariableName(String varname) {
        if (!StringUtils.isNullOrEmpty(varname)) {
            return NameMasking.unmask(StringUtils.reverseKeywords(varname).replace("_var", ""));
        }
        return varname;
    }
}

