/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.utils;

import io.openvalidation.common.utils.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberParsingUtils {
    public static boolean isParsableFloat(String input) {
        try {
            Float.parseFloat(input);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static Double extractDouble(String value) {
        String str;
        Pattern regex = Pattern.compile("-?(\\b[0-9]+(,[0-9]{3})*(\\.[0-9]+)?\\b|\\.\\b[0-9]+)\\b");
        Matcher matcher = regex.matcher(value);
        if (matcher.find() && !StringUtils.isNullOrEmpty(str = matcher.group(0))) {
            return new Double(str);
        }
        return null;
    }

    public static boolean isDouble(String input) {
        try {
            Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isNumber(String value) {
        boolean result = false;
        if (value != null) {
            String v = value.trim();
            if (v.length() > 0 && org.apache.commons.lang.StringUtils.isNumeric((String)v)) {
                if (v.length() <= 1 || !v.startsWith("0")) {
                    result = true;
                }
            } else if (NumberParsingUtils.isDouble(v) && (v.startsWith("0.") || !v.startsWith("0"))) {
                result = true;
            }
        }
        return result;
    }

    public static boolean containsNumber(String value) {
        if (value != null && !value.isEmpty()) {
            for (String val : value.split(" ")) {
                String v;
                if (val == null || (v = val.trim()).isEmpty() || !org.apache.commons.lang.StringUtils.isNumeric((String)v) && !NumberParsingUtils.isDouble(v)) continue;
                return v.length() <= 1 || !v.startsWith("0");
            }
        }
        return false;
    }

    public static Double extractNumber(String value) {
        if (value != null && !value.isEmpty()) {
            for (String val : value.split(" ")) {
                String v;
                if (val == null || (v = val.trim()).isEmpty() || !org.apache.commons.lang.StringUtils.isNumeric((String)v) && !NumberParsingUtils.isDouble(v)) continue;
                return Double.parseDouble(v);
            }
        }
        return null;
    }
}

