/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.utils;

import io.openvalidation.common.utils.StringUtils;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExUtils {
    public static String PARAGRAPH_REGEX = "([ ]*\n[ ]*){2,}";
    private static Pattern arithmeticalTimesCollision = Pattern.compile("(\u02acarithmoperator\u02acmultiply\u02ac)times(\\s| )+\u02acarithmoperator\u02ac", 2);

    public static boolean hasArithmeticalTimesCollision(String value) {
        return RegExUtils.hasMatch(arithmeticalTimesCollision, value);
    }

    public static String fixArithmeticalTimesCollision(String value) {
        return RegExUtils.replace(arithmeticalTimesCollision, value, "");
    }

    public static boolean hasMatch(Pattern pattern, String value) {
        if (!StringUtils.isNullOrEmpty(value)) {
            return arithmeticalTimesCollision.matcher(value).find();
        }
        return false;
    }

    public static String replace(Pattern pattern, String input, String replaceWord) {
        String output = input;
        if (!StringUtils.isNullOrEmpty(input)) {
            String replacement;
            Matcher matcher = pattern.matcher(input);
            String string = replacement = StringUtils.isNullOrEmpty(replaceWord) ? "" : StringUtils.encodeRegex(replaceWord);
            while (matcher.find()) {
                String res = matcher.group(1);
                int start = matcher.start(1);
                int end = start + res.length();
                if (start <= -1) continue;
                output = output.substring(0, start) + replacement + output.substring(end);
                return output;
            }
        }
        return output;
    }

    public static void each(String regex, String input, Consumer<? super Matcher> clbk) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            clbk.accept(matcher);
        }
    }

    public static String firstGroup(String regex, String input) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

