/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.utils;

import io.openvalidation.common.utils.ClassPathURLHandler;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public class ResourceUtils {
    private static final String cultureResourcePrefix = "aliases_";
    private static final String cultureResourceExt = ".properties";

    public static String getPathWithoutResourceName(String resourceName) {
        String path = ResourceUtils.getPath(resourceName, null);
        if (path != null) {
            return path.substring(0, path.lastIndexOf(47));
        }
        return null;
    }

    public static String getPath(String resourceName) {
        return ResourceUtils.getPath(resourceName, null);
    }

    public static String getPath(String resourceName, Class classOfResourcePackage) {
        try {
            Class cls = classOfResourcePackage == null ? ResourceUtils.getCallerClass() : classOfResourcePackage;
            return String.format("classpath:" + resourceName, new Object[0]).replace("classpath:/", "classpath:");
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static String getResourceContentByClassPath(String resourceClassPath) {
        if (resourceClassPath == null) {
            return null;
        }
        try {
            String rp = resourceClassPath.replace("classpath:/", "classpath:");
            URL url = new URL(null, rp, new ClassPathURLHandler());
            return ResourceUtils.getContentFromInputStream(url.openStream());
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static String getResourceConent(String resourceName) {
        return ResourceUtils.getResourceConent(resourceName, null);
    }

    public static String getResourceConent(String resourceName, Class classOfResourcePackage) {
        if (resourceName == null) {
            return null;
        }
        try {
            if (resourceName.startsWith("classpath")) {
                return ResourceUtils.getResourceContentByClassPath(resourceName);
            }
            Class cls = classOfResourcePackage == null ? ResourceUtils.getCallerClass() : classOfResourcePackage;
            return ResourceUtils.getContentFromInputStream(cls.getClassLoader().getResourceAsStream(resourceName));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean exists(String resourceName) {
        if (resourceName == null) {
            return false;
        }
        try {
            URL url = null;
            boolean streamNotNull = false;
            if (resourceName.startsWith("classpath")) {
                String rp = resourceName.replace("classpath:/", "classpath:");
                URL tmp = new URL(null, rp, new ClassPathURLHandler());
                InputStream stream = tmp.openStream();
                if (stream != null) {
                    streamNotNull = true;
                    stream.close();
                }
                return streamNotNull;
            }
            if (resourceName.startsWith("/")) {
                resourceName = resourceName.substring(1);
            }
            return (url = ResourceUtils.getCallerClass().getClassLoader().getResource(resourceName)) != null;
        }
        catch (Exception exp) {
            return false;
        }
    }

    public static Class getCallerClass() throws Exception {
        String callerClassName = Thread.currentThread().getStackTrace()[2].getClassName();
        return Class.forName(callerClassName);
    }

    public static List<String> getAvailableCultures() {
        ArrayList<String> localesList = new ArrayList<String>();
        Set localesSet = Arrays.stream(Locale.getAvailableLocales()).map(Locale::getLanguage).collect(Collectors.toSet());
        for (String lang : localesSet) {
            if (!ResourceUtils.exists(cultureResourcePrefix + lang + cultureResourceExt)) continue;
            localesList.add(lang);
        }
        return localesList;
    }

    private static String getContentFromInputStream(InputStream is) {
        if (is != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            return reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        return null;
    }
}

