/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.common.validation;

import io.openvalidation.common.ast.ASTItem;
import io.openvalidation.common.exceptions.ASTValidationException;
import io.openvalidation.common.validation.Validator;
import java.util.List;

public class ASTValidator {
    public static <T> void shouldNotBeEmpty(T value, String paramName, ASTItem item, String ... customMessage) throws ASTValidationException {
        if (value == null) {
            throw new ASTValidationException(ASTValidator.getErrorMessage(Validator.ValidatorErrorKind.NotEmpty, paramName, customMessage), item);
        }
        if (value instanceof String && ((String)value).length() < 1) {
            throw new ASTValidationException(ASTValidator.getErrorMessage(Validator.ValidatorErrorKind.NotEmpty, paramName, customMessage), item);
        }
        if (value instanceof List && ((List)value).size() < 1) {
            throw new ASTValidationException(ASTValidator.getErrorMessage(Validator.ValidatorErrorKind.NotEmpty, paramName, customMessage), item);
        }
    }

    private static String getErrorMessage(Validator.ValidatorErrorKind kind, String paramName, String ... customMessage) {
        String error;
        if (customMessage != null && customMessage.length > 0 && (error = String.join((CharSequence)" ", customMessage)).length() > 0) {
            return error;
        }
        return Validator.getUserErrorMessage(kind, paramName);
    }
}

