/*
 * Decompiled with CFR 0.152.
 */
package io.orangebuffalo.testcontainers.playwright;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.Selectors;
import io.orangebuffalo.testcontainers.playwright.PlaywrightApi;
import io.orangebuffalo.testcontainers.playwright.PlaywrightApiManager;
import io.orangebuffalo.testcontainers.playwright.PlaywrightContainer;
import io.orangebuffalo.testcontainers.playwright.PlaywrightUtilsKt;
import io.orangebuffalo.testcontainers.playwright.shadow.org.jetbrains.annotations.NotNull;
import io.orangebuffalo.testcontainers.playwright.shadow.org.jetbrains.annotations.Nullable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bR\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/orangebuffalo/testcontainers/playwright/PlaywrightApiManager;", "", "container", "Lio/orangebuffalo/testcontainers/playwright/PlaywrightContainer;", "(Lio/orangebuffalo/testcontainers/playwright/PlaywrightContainer;)V", "playwrightApis", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lio/orangebuffalo/testcontainers/playwright/PlaywrightApiManager$PlaywrightApiImpl;", "close", "", "getPlaywrightApi", "Lio/orangebuffalo/testcontainers/playwright/PlaywrightApi;", "PlaywrightApiImpl", "testcontainers-playwright"})
@SourceDebugExtension(value={"SMAP\nPlaywrightApiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaywrightApiManager.kt\nio/orangebuffalo/testcontainers/playwright/PlaywrightApiManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1855#2,2:75\n*S KotlinDebug\n*F\n+ 1 PlaywrightApiManager.kt\nio/orangebuffalo/testcontainers/playwright/PlaywrightApiManager\n*L\n18#1:75,2\n*E\n"})
public final class PlaywrightApiManager {
    @NotNull
    private final PlaywrightContainer container;
    @NotNull
    private final ConcurrentHashMap<Long, PlaywrightApiImpl> playwrightApis;

    public PlaywrightApiManager(@NotNull PlaywrightContainer container2) {
        Intrinsics.checkNotNullParameter((Object)((Object)container2), (String)"container");
        this.container = container2;
        this.playwrightApis = new ConcurrentHashMap();
    }

    public final void close() {
        Collection<PlaywrightApiImpl> collection = this.playwrightApis.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"playwrightApis.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlaywrightApiImpl it = (PlaywrightApiImpl)element$iv;
            boolean bl = false;
            it.close();
        }
    }

    @NotNull
    public final PlaywrightApi getPlaywrightApi() {
        PlaywrightApiImpl playwrightApiImpl = this.playwrightApis.computeIfAbsent(Thread.currentThread().getId(), arg_0 -> PlaywrightApiManager.getPlaywrightApi$lambda$1((Function1)new Function1<Long, PlaywrightApiImpl>(this){
            final /* synthetic */ PlaywrightApiManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final PlaywrightApiImpl invoke(@NotNull Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PlaywrightApiImpl api = this.this$0.new PlaywrightApiImpl();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> getPlaywrightApi.1.invoke$lambda$0(api)));
                return api;
            }

            private static final void invoke$lambda$0(PlaywrightApiImpl $api) {
                Intrinsics.checkNotNullParameter((Object)$api, (String)"$api");
                $api.close();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)playwrightApiImpl, (String)"fun getPlaywrightApi(): \u2026     })\n        api\n    }");
        return playwrightApiImpl;
    }

    private static final PlaywrightApiImpl getPlaywrightApi$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PlaywrightApiImpl)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u0004H\u0016J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/orangebuffalo/testcontainers/playwright/PlaywrightApiManager$PlaywrightApiImpl;", "Lio/orangebuffalo/testcontainers/playwright/PlaywrightApi;", "(Lio/orangebuffalo/testcontainers/playwright/PlaywrightApiManager;)V", "chromiumBrowser", "Lcom/microsoft/playwright/Browser;", "firefoxBrowser", "playwright", "Lcom/microsoft/playwright/Playwright;", "kotlin.jvm.PlatformType", "webkitBrowser", "chromium", "close", "", "firefox", "selectors", "Lcom/microsoft/playwright/Selectors;", "webkit", "testcontainers-playwright"})
    private final class PlaywrightApiImpl
    implements PlaywrightApi {
        private final Playwright playwright = Playwright.create((Playwright.CreateOptions)new Playwright.CreateOptions().setEnv(MapsKt.mapOf((Pair)TuplesKt.to((Object)"PLAYWRIGHT_SKIP_BROWSER_DOWNLOAD", (Object)"1"))));
        @Nullable
        private Browser chromiumBrowser;
        @Nullable
        private Browser firefoxBrowser;
        @Nullable
        private Browser webkitBrowser;

        @Override
        @NotNull
        public Browser chromium() {
            if (this.chromiumBrowser == null) {
                this.chromiumBrowser = this.playwright.chromium().connect(PlaywrightApiManager.this.container.getChromiumWsEndpoint$testcontainers_playwright());
            }
            Browser browser = this.chromiumBrowser;
            Intrinsics.checkNotNull((Object)browser);
            return browser;
        }

        @Override
        @NotNull
        public Browser firefox() {
            if (this.firefoxBrowser == null) {
                this.firefoxBrowser = this.playwright.firefox().connect(PlaywrightApiManager.this.container.getFirefoxWsEndpoint$testcontainers_playwright());
            }
            Browser browser = this.firefoxBrowser;
            Intrinsics.checkNotNull((Object)browser);
            return browser;
        }

        @Override
        @NotNull
        public Browser webkit() {
            if (this.webkitBrowser == null) {
                this.webkitBrowser = this.playwright.webkit().connect(PlaywrightApiManager.this.container.getWebkitWsEndpoint$testcontainers_playwright());
            }
            Browser browser = this.webkitBrowser;
            Intrinsics.checkNotNull((Object)browser);
            return browser;
        }

        @Override
        @NotNull
        public Selectors selectors() {
            Selectors selectors = this.playwright.selectors();
            Intrinsics.checkNotNullExpressionValue((Object)selectors, (String)"playwright.selectors()");
            return selectors;
        }

        public final void close() {
            Browser browser = this.chromiumBrowser;
            if (browser != null) {
                PlaywrightUtilsKt.safeClose(browser);
            }
            Browser browser2 = this.firefoxBrowser;
            if (browser2 != null) {
                PlaywrightUtilsKt.safeClose(browser2);
            }
            Browser browser3 = this.webkitBrowser;
            if (browser3 != null) {
                PlaywrightUtilsKt.safeClose(browser3);
            }
            Playwright playwright = this.playwright;
            Intrinsics.checkNotNullExpressionValue((Object)playwright, (String)"playwright");
            PlaywrightUtilsKt.safeClose(playwright);
        }
    }
}

