/*
 * Decompiled with CFR 0.152.
 */
package io.orangebuffalo.testcontainers.playwright.junit;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.Selectors;
import io.orangebuffalo.testcontainers.playwright.PlaywrightApi;
import io.orangebuffalo.testcontainers.playwright.PlaywrightUtilsKt;
import io.orangebuffalo.testcontainers.playwright.junit.PlaywrightApiProvider;
import io.orangebuffalo.testcontainers.playwright.shadow.org.jetbrains.annotations.NotNull;
import io.orangebuffalo.testcontainers.playwright.shadow.org.jetbrains.annotations.Nullable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/orangebuffalo/testcontainers/playwright/junit/LocalPlaywrightApiProvider;", "Lio/orangebuffalo/testcontainers/playwright/junit/PlaywrightApiProvider;", "()V", "playwrightApis", "Ljava/lang/ThreadLocal;", "Lio/orangebuffalo/testcontainers/playwright/junit/LocalPlaywrightApiProvider$LocalPlaywrightApiImpl;", "kotlin.jvm.PlatformType", "getOrCreatePlaywrightApiForCurrentThread", "Lio/orangebuffalo/testcontainers/playwright/PlaywrightApi;", "LocalPlaywrightApiImpl", "testcontainers-playwright"})
public final class LocalPlaywrightApiProvider
implements PlaywrightApiProvider {
    private final ThreadLocal<LocalPlaywrightApiImpl> playwrightApis = ThreadLocal.withInitial(LocalPlaywrightApiProvider::playwrightApis$lambda$1);

    @Override
    @NotNull
    public PlaywrightApi getOrCreatePlaywrightApiForCurrentThread() {
        LocalPlaywrightApiImpl localPlaywrightApiImpl = this.playwrightApis.get();
        Intrinsics.checkNotNullExpressionValue((Object)localPlaywrightApiImpl, (String)"playwrightApis.get()");
        return localPlaywrightApiImpl;
    }

    private static final void playwrightApis$lambda$1$lambda$0(LocalPlaywrightApiImpl $api) {
        Intrinsics.checkNotNullParameter((Object)$api, (String)"$api");
        $api.close();
    }

    private static final LocalPlaywrightApiImpl playwrightApis$lambda$1() {
        LocalPlaywrightApiImpl api = new LocalPlaywrightApiImpl();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> LocalPlaywrightApiProvider.playwrightApis$lambda$1$lambda$0(api)));
        return api;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u0004H\u0016J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/orangebuffalo/testcontainers/playwright/junit/LocalPlaywrightApiProvider$LocalPlaywrightApiImpl;", "Lio/orangebuffalo/testcontainers/playwright/PlaywrightApi;", "()V", "chromiumBrowser", "Lcom/microsoft/playwright/Browser;", "firefoxBrowser", "playwright", "Lcom/microsoft/playwright/Playwright;", "kotlin.jvm.PlatformType", "webkitBrowser", "chromium", "close", "", "firefox", "selectors", "Lcom/microsoft/playwright/Selectors;", "webkit", "testcontainers-playwright"})
    private static final class LocalPlaywrightApiImpl
    implements PlaywrightApi {
        private final Playwright playwright = Playwright.create();
        @Nullable
        private Browser chromiumBrowser;
        @Nullable
        private Browser firefoxBrowser;
        @Nullable
        private Browser webkitBrowser;

        @Override
        @NotNull
        public Browser chromium() {
            if (this.chromiumBrowser == null) {
                this.chromiumBrowser = this.playwright.chromium().launch(new BrowserType.LaunchOptions().setHeadless(false));
            }
            Browser browser = this.chromiumBrowser;
            Intrinsics.checkNotNull((Object)browser);
            return browser;
        }

        @Override
        @NotNull
        public Browser firefox() {
            if (this.firefoxBrowser == null) {
                this.firefoxBrowser = this.playwright.firefox().launch(new BrowserType.LaunchOptions().setHeadless(false));
            }
            Browser browser = this.firefoxBrowser;
            Intrinsics.checkNotNull((Object)browser);
            return browser;
        }

        @Override
        @NotNull
        public Browser webkit() {
            if (this.webkitBrowser == null) {
                this.webkitBrowser = this.playwright.webkit().launch(new BrowserType.LaunchOptions().setHeadless(false));
            }
            Browser browser = this.webkitBrowser;
            Intrinsics.checkNotNull((Object)browser);
            return browser;
        }

        @Override
        @NotNull
        public Selectors selectors() {
            Selectors selectors = this.playwright.selectors();
            Intrinsics.checkNotNullExpressionValue((Object)selectors, (String)"playwright.selectors()");
            return selectors;
        }

        public final void close() {
            Browser browser = this.chromiumBrowser;
            if (browser != null) {
                PlaywrightUtilsKt.safeClose(browser);
            }
            Browser browser2 = this.firefoxBrowser;
            if (browser2 != null) {
                PlaywrightUtilsKt.safeClose(browser2);
            }
            Browser browser3 = this.webkitBrowser;
            if (browser3 != null) {
                PlaywrightUtilsKt.safeClose(browser3);
            }
            Playwright playwright = this.playwright;
            Intrinsics.checkNotNullExpressionValue((Object)playwright, (String)"playwright");
            PlaywrightUtilsKt.safeClose(playwright);
        }
    }
}

