/*
 * Decompiled with CFR 0.152.
 */
package io.orkes.conductor.mq;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class QueueMessage {
    private String id;
    private String payload;
    private long timeout;
    private int priority;
    private long expiry;

    public QueueMessage(String id, String payload) {
        this(id, payload, 0L, 100);
    }

    public QueueMessage(String id, String payload, long timeout) {
        this(id, payload, timeout, 100);
    }

    public QueueMessage(String id, String payload, long timeout, int priority) {
        this.id = id;
        this.payload = payload;
        this.timeout = timeout;
        this.priority = priority;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeUnit.convert(timeout, TimeUnit.MILLISECONDS);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueMessage message = (QueueMessage)o;
        return Objects.equals(this.id, message.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

