/*
 * Decompiled with CFR 0.152.
 */
package io.orkes.conductor.mq.redis.cluster;

import io.orkes.conductor.mq.redis.QueueMonitor;
import io.orkes.conductor.mq.redis.QueueMonitorProperties;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.exceptions.JedisNoScriptException;

public class ClusteredQueueMonitor
extends QueueMonitor {
    private static final Logger log = LoggerFactory.getLogger(ClusteredQueueMonitor.class);
    private final JedisCluster jedisCluster;
    private final String scriptSha;
    private final String queueName;

    public ClusteredQueueMonitor(JedisCluster jedisCluster, String queueName, QueueMonitorProperties queueMonitorProperties) {
        super(queueName);
        this.queueName = queueName;
        this.jedisCluster = jedisCluster;
        this.scriptSha = this.loadScript();
        this.setMaxPollCount(queueMonitorProperties.getMaxPollCount());
    }

    private String loadScript() {
        try {
            InputStream stream = this.getClass().getResourceAsStream("/pop_batch.lua");
            byte[] script = stream.readAllBytes();
            byte[] response = this.jedisCluster.scriptLoad(script, this.queueName.getBytes(StandardCharsets.UTF_8));
            String sha = new String(response);
            return sha;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected long queueSize() {
        return this.jedisCluster.zcard(this.queueName);
    }

    @Override
    protected List<String> pollMessages(double now, double maxTime, int batchSize) {
        try {
            Object popResponse = this.jedisCluster.evalsha(this.scriptSha, Arrays.asList(this.queueName), Arrays.asList("" + now, "" + maxTime, "" + batchSize));
            if (popResponse == null) {
                return null;
            }
            return (List)popResponse;
        }
        catch (JedisNoScriptException jedisNoScriptException) {
            this.loadScript();
            return null;
        }
    }
}

