/*
 * Decompiled with CFR 0.152.
 */
package io.orkes.conductor.mq.redis.single;

import io.orkes.conductor.mq.redis.QueueMonitor;
import io.orkes.conductor.mq.redis.QueueMonitorProperties;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.exceptions.JedisNoScriptException;

public class RedisQueueMonitor
extends QueueMonitor {
    private static final Logger log = LoggerFactory.getLogger(RedisQueueMonitor.class);
    private final JedisPoolAbstract jedisPool;
    private final String queueName;
    private final String scriptSha;

    public RedisQueueMonitor(JedisPoolAbstract jedisPool, String queueName, QueueMonitorProperties queueMonitorProperties) {
        super(queueName);
        this.jedisPool = jedisPool;
        this.queueName = queueName;
        this.scriptSha = this.loadScript();
        this.setMaxPollCount(queueMonitorProperties.getMaxPollCount());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<String> pollMessages(double now, double maxTime, int batchSize) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Object popResponse = jedis.evalsha(this.scriptSha, Arrays.asList(this.queueName), Arrays.asList("" + now, "" + maxTime, "" + batchSize));
            if (popResponse == null) {
                List<String> list2 = null;
                return list2;
            }
            List list = (List)popResponse;
            return list;
        }
        catch (JedisNoScriptException noScriptException) {
            this.loadScript();
            return null;
        }
    }

    @Override
    protected long queueSize() {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            long l = jedis.zcard(this.queueName);
            return l;
        }
    }

    private String loadScript() {
        String string;
        block8: {
            InputStream stream = this.getClass().getResourceAsStream("/pop_batch.lua");
            byte[] script = stream.readAllBytes();
            Jedis jedis = (Jedis)this.jedisPool.getResource();
            try {
                byte[] response = jedis.scriptLoad(script);
                string = new String(response);
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            jedis.close();
        }
        return string;
    }
}

