/*
 * Decompiled with CFR 0.152.
 */
package io.orkes.conductor.mq.redis.single;

import io.orkes.conductor.mq.ConductorQueue;
import io.orkes.conductor.mq.QueueMessage;
import io.orkes.conductor.mq.redis.QueueMonitor;
import io.orkes.conductor.mq.redis.single.RedisQueueMonitor;
import java.math.BigDecimal;
import java.time.Clock;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.params.ZAddParams;

public class ConductorRedisQueue
implements ConductorQueue {
    private static final Logger log = LoggerFactory.getLogger(ConductorRedisQueue.class);
    private final JedisPoolAbstract jedisPool;
    private final Clock clock;
    private String queueName;
    private final String payloadKey;
    private final QueueMonitor queueMonitor;

    public ConductorRedisQueue(String queueName, JedisPoolAbstract jedisPool) {
        this.jedisPool = jedisPool;
        this.clock = Clock.systemDefaultZone();
        this.queueName = queueName;
        this.payloadKey = queueName + "_payload";
        this.queueMonitor = new RedisQueueMonitor(jedisPool, queueName);
        log.info("ConductorRedisQueue started serving {}", (Object)queueName);
    }

    @Override
    public String getName() {
        return this.queueName;
    }

    @Override
    public List<QueueMessage> pop(int count, int waitTime, TimeUnit timeUnit) {
        List<QueueMessage> messages = this.queueMonitor.pop(count, waitTime, timeUnit);
        if (messages.isEmpty()) {
            return messages;
        }
        String[] messageIds = (String[])messages.stream().map(QueueMessage::getId).toArray(String[]::new);
        List<String> payloads = this.getPayloads(messageIds);
        for (int i = 0; i < messages.size(); ++i) {
            messages.get(i).setPayload(payloads.get(i));
        }
        return messages;
    }

    @Override
    public boolean ack(String messageId) {
        Long removed;
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            removed = jedis.zrem(this.queueName, new String[]{messageId});
            jedis.hdel(this.payloadKey, new String[]{messageId});
        }
        return removed > 0L;
    }

    @Override
    public void remove(String messageId) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.zrem(this.queueName, new String[]{messageId});
            jedis.hdel(this.payloadKey, new String[]{messageId});
        }
    }

    @Override
    public void push(List<QueueMessage> messages) {
        long now = this.clock.millis();
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Pipeline pipe = jedis.pipelined();
            for (QueueMessage msg : messages) {
                double score = this.getScore(now, msg);
                String messageId = msg.getId();
                pipe.zadd(this.queueName, score, messageId);
                if (!StringUtils.isNotBlank((CharSequence)msg.getPayload())) continue;
                pipe.hset(this.payloadKey, msg.getId(), msg.getPayload());
            }
            pipe.sync();
            pipe.close();
        }
    }

    @Override
    public boolean setUnacktimeout(String messageId, long unackTimeout) {
        double score = this.clock.millis() + unackTimeout;
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            ZAddParams params = ZAddParams.zAddParams().xx().ch();
            Long modified = jedis.zadd(this.queueName, score, messageId, params);
            boolean bl = modified != null && modified > 0L;
            return bl;
        }
    }

    @Override
    public boolean exists(String messageId) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Double score = jedis.zscore(this.queueName, messageId);
            if (score != null) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public QueueMessage get(String messageId) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            QueueMessage message;
            Double score = jedis.zscore(this.queueName, messageId);
            if (score == null) {
                QueueMessage queueMessage = null;
                return queueMessage;
            }
            int priority = new BigDecimal(score).remainder(BigDecimal.ONE).multiply(HUNDRED).intValue();
            String payload = jedis.hget(this.payloadKey, messageId);
            QueueMessage queueMessage = message = new QueueMessage(messageId, payload, score.longValue(), priority);
            return queueMessage;
        }
    }

    @Override
    public void flush() {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.del(this.queueName);
            jedis.del(this.payloadKey);
        }
    }

    @Override
    public long size() {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            long l = jedis.zcard(this.queueName);
            return l;
        }
    }

    @Override
    public int getQueueUnackTime() {
        return this.queueMonitor.getQueueUnackTime();
    }

    @Override
    public void setQueueUnackTime(int queueUnackTime) {
        this.queueMonitor.setQueueUnackTime(queueUnackTime);
    }

    @Override
    public String getShardName() {
        return null;
    }

    private List<String> getPayloads(String[] messageIds) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List payloads;
            List list = payloads = jedis.hmget(this.payloadKey, messageIds);
            return list;
        }
    }
}

