/*
 * Decompiled with CFR 0.152.
 */
package io.orkes.conductor.mq;

import io.orkes.conductor.mq.QueueMessage;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import java.util.concurrent.TimeUnit;

public interface ConductorQueue {
    public static final BigDecimal HUNDRED = new BigDecimal(100);
    public static final BigDecimal MILLION = new BigDecimal(1000000);
    public static final MathContext PRECISION_MC = new MathContext(20);

    public String getName();

    public List<QueueMessage> pop(int var1, int var2, TimeUnit var3);

    public boolean ack(String var1);

    public void push(List<QueueMessage> var1);

    public boolean setUnacktimeout(String var1, long var2);

    public boolean exists(String var1);

    public void remove(String var1);

    public QueueMessage get(String var1);

    public void flush();

    public long size();

    public int getQueueUnackTime();

    public void setQueueUnackTime(int var1);

    public String getShardName();

    default public double getScore(long now, QueueMessage msg) {
        double score = 0.0;
        if (msg.getTimeout() > 0L) {
            BigDecimal timeout = new BigDecimal(now + msg.getTimeout());
            BigDecimal divideByOne = BigDecimal.ONE.divide(new BigDecimal(msg.getPriority() + 1), PRECISION_MC);
            BigDecimal oneMinusDivByOne = BigDecimal.ONE.subtract(divideByOne);
            BigDecimal bd = timeout.add(oneMinusDivByOne);
            score = bd.doubleValue();
        } else {
            score = msg.getPriority() > 0 ? (double)msg.getPriority() : (double)now;
        }
        return score;
    }
}

