/*
 * Decompiled with CFR 0.152.
 */
package io.orkes.conductor.mq.redis.cluster;

import io.orkes.conductor.mq.ConductorQueue;
import io.orkes.conductor.mq.QueueMessage;
import io.orkes.conductor.mq.redis.QueueMonitorProperties;
import io.orkes.conductor.mq.redis.cluster.ClusteredQueueMonitor;
import java.math.BigDecimal;
import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.params.ZAddParams;

public class ConductorRedisClusterQueue
implements ConductorQueue {
    private static final Logger log = LoggerFactory.getLogger(ConductorRedisClusterQueue.class);
    private int queueUnackTime = 30000;
    private final JedisCluster jedis;
    private final Clock clock;
    private final String queueName;
    private final String payloadKey;
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private final ClusteredQueueMonitor queueMonitor;

    public ConductorRedisClusterQueue(String queueName, JedisCluster jedisCluster, QueueMonitorProperties queueMonitorProperties) {
        this.jedis = jedisCluster;
        this.clock = Clock.systemDefaultZone();
        this.queueName = queueName;
        this.payloadKey = queueName + "_payload";
        this.queueMonitor = new ClusteredQueueMonitor(jedisCluster, queueName, queueMonitorProperties);
        log.info("ConductorRedisClusterQueue started serving {}", (Object)queueName);
    }

    @Override
    public String getName() {
        return this.queueName;
    }

    @Override
    public List<QueueMessage> pop(int count, int waitTime, TimeUnit timeUnit) {
        List<QueueMessage> messages = this.queueMonitor.pop(count, waitTime, timeUnit);
        if (messages.isEmpty()) {
            return messages;
        }
        String[] messageIds = (String[])messages.stream().map(QueueMessage::getId).toArray(String[]::new);
        List<String> payloads = this.getPayloads(messageIds);
        for (int i = 0; i < messages.size(); ++i) {
            messages.get(i).setPayload(payloads.get(i));
        }
        return messages;
    }

    @Override
    public boolean ack(String messageId) {
        Long removed = this.jedis.zrem(this.queueName, new String[]{messageId});
        this.jedis.hdel(this.payloadKey, new String[]{messageId});
        return removed > 0L;
    }

    @Override
    public void push(List<QueueMessage> messages) {
        long now = this.clock.millis();
        HashMap<String, Double> scoreMembers = new HashMap<String, Double>(messages.size());
        HashMap<String, String> payloads = new HashMap<String, String>();
        for (QueueMessage msg : messages) {
            double score = this.getScore(now, msg);
            String messageId = msg.getId();
            scoreMembers.put(messageId, score);
            if (!StringUtils.isNotBlank((CharSequence)msg.getPayload())) continue;
            payloads.put(messageId, msg.getPayload());
        }
        this.jedis.zadd(this.queueName, scoreMembers);
        if (!payloads.isEmpty()) {
            this.jedis.hmset(this.payloadKey, payloads);
        }
    }

    @Override
    public boolean setUnacktimeout(String messageId, long unackTimeout) {
        ZAddParams params;
        double score = this.clock.millis() + unackTimeout;
        Long modified = this.jedis.zadd(this.queueName, score, messageId, params = ZAddParams.zAddParams().xx().ch());
        return modified != null && modified > 0L;
    }

    @Override
    public boolean exists(String messageId) {
        Double score = this.jedis.zscore(this.queueName, messageId);
        return score != null;
    }

    @Override
    public void remove(String messageId) {
        this.jedis.zrem(this.queueName, new String[]{messageId});
        this.jedis.hdel(this.payloadKey, new String[]{messageId});
    }

    @Override
    public QueueMessage get(String messageId) {
        Double score = this.jedis.zscore(this.queueName, messageId);
        if (score == null) {
            return null;
        }
        int priority = new BigDecimal(score).remainder(BigDecimal.ONE).multiply(HUNDRED).intValue();
        String payload = this.jedis.hget(this.payloadKey, messageId);
        QueueMessage message = new QueueMessage(messageId, payload, score.longValue(), priority);
        return message;
    }

    @Override
    public void flush() {
        this.jedis.del(this.queueName);
        this.jedis.del(this.payloadKey);
    }

    @Override
    public long size() {
        return this.jedis.zcard(this.queueName);
    }

    @Override
    public int getQueueUnackTime() {
        return this.queueUnackTime;
    }

    @Override
    public void setQueueUnackTime(int queueUnackTime) {
        this.queueUnackTime = queueUnackTime;
    }

    @Override
    public String getShardName() {
        return null;
    }

    private List<String> getPayloads(String[] messageIds) {
        List payloads = this.jedis.hmget(this.payloadKey, messageIds);
        return payloads;
    }
}

