/*
 * Decompiled with CFR 0.152.
 */
package io.othree.composer;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.othree.composer.TemplateComposer;
import io.othree.composer.configuration.MustacheComposerConfiguration;
import io.othree.composer.data.files.MustacheTemplateRepository;
import io.othree.composer.exceptions.TemplateNotFoundException;
import io.othree.composer.models.MustacheTemplateKey;
import io.othree.envelope.models.Envelope;
import io.othree.ocular.DataSource;
import java.io.File;
import java.io.Serializable;
import org.fusesource.scalate.Template;
import org.fusesource.scalate.TemplateEngine;
import org.fusesource.scalate.TemplateEngine$;
import org.fusesource.scalate.TemplateSource;
import org.fusesource.scalate.TemplateSource$;
import org.fusesource.scalate.support.SourceTemplateSource;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u0013\tAR*^:uC\u000eDW\rV3na2\fG/Z\"p[B|7/\u001a:\u000b\u0005\r!\u0011\u0001C2p[B|7/\u001a:\u000b\u0005\u00151\u0011AB8uQJ,WMC\u0001\b\u0003\tIwn\u0001\u0001\u0014\t\u0001Q\u0001\u0003\u0006\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!\u0001\u0005+f[Bd\u0017\r^3D_6\u0004xn]3s!\t)B$D\u0001\u0017\u0015\t9\u0002$\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002\u001a5\u0005AA/\u001f9fg\u00064WMC\u0001\u001c\u0003\r\u0019w.\\\u0005\u0003;Y\u00111\u0002T1{s2{wmZ5oO\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0004d_:4\u0017n\u001a\t\u0003C\u0011j\u0011A\t\u0006\u0003G\t\tQbY8oM&<WO]1uS>t\u0017BA\u0013#\u0005uiUo\u001d;bG\",7i\\7q_N,'oQ8oM&<WO]1uS>t\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u000255,8\u000f^1dQ\u0016$V-\u001c9mCR,'+\u001a9pg&$xN]=\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013!\u00024jY\u0016\u001c(BA\u0017\u0003\u0003\u0011!\u0017\r^1\n\u0005=R#AG'vgR\f7\r[3UK6\u0004H.\u0019;f%\u0016\u0004xn]5u_JL\b\u0002C\u0019\u0001\u0005\u0003\u0005\u000b1\u0002\u001a\u0002\u0005\u0015\u001c\u0007CA\u001a7\u001b\u0005!$BA\u001b\r\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003oQ\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000be\u0002A\u0011\u0001\u001e\u0002\rqJg.\u001b;?)\rYdh\u0010\u000b\u0003yu\u0002\"!\u0005\u0001\t\u000bEB\u00049\u0001\u001a\t\u000b}A\u0004\u0019\u0001\u0011\t\u000b\u001dB\u0004\u0019\u0001\u0015\t\u000f\u0005\u0003!\u0019!C\u0005\u0005\u00061QM\\4j]\u0016,\u0012a\u0011\t\u0003\t.k\u0011!\u0012\u0006\u0003\r\u001e\u000bqa]2bY\u0006$XM\u0003\u0002I\u0013\u0006Qa-^:fg>,(oY3\u000b\u0003)\u000b1a\u001c:h\u0013\taUI\u0001\bUK6\u0004H.\u0019;f\u000b:<\u0017N\\3\t\r9\u0003\u0001\u0015!\u0003D\u0003\u001d)gnZ5oK\u0002BQ\u0001\u0015\u0001\u0005BE\u000bqaY8na>\u001cX\r\u0006\u0002SAB\u00191gU+\n\u0005Q#$A\u0002$viV\u0014X\r\u0005\u0002W;:\u0011qk\u0017\t\u000312i\u0011!\u0017\u0006\u00035\"\ta\u0001\u0010:p_Rt\u0014B\u0001/\r\u0003\u0019\u0001&/\u001a3fM&\u0011al\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qc\u0001\"B1P\u0001\u0004\u0011\u0017\u0001C3om\u0016dw\u000e]3\u0011\u0005\r<W\"\u00013\u000b\u0005\u00154\u0017AB7pI\u0016d7O\u0003\u0002b\t%\u0011\u0001\u000e\u001a\u0002\t\u000b:4X\r\\8qK\u0002")
public class MustacheTemplateComposer
implements TemplateComposer,
LazyLogging {
    private final MustacheTemplateRepository mustacheTemplateRepository;
    private final ExecutionContext ec;
    private final TemplateEngine engine;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        MustacheTemplateComposer mustacheTemplateComposer = this;
        synchronized (mustacheTemplateComposer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private TemplateEngine engine() {
        return this.engine;
    }

    @Override
    public Future<String> compose(Envelope envelope) {
        String templateKey = this.mustacheTemplateRepository.getKey(new MustacheTemplateKey(envelope.templateId()));
        return this.mustacheTemplateRepository.get(new MustacheTemplateKey(envelope.templateId()), ClassTag$.MODULE$.apply(DataSource.class)).map((Function1 & Serializable & scala.Serializable)maybeTemplate -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (maybeTemplate.isEmpty()) {
                throw new TemplateNotFoundException(envelope.templateId(), new StringBuilder(29).append("Template ").append(envelope.templateId()).append(" not found in path: ").append(templateKey).toString());
            }
            DataSource mustacheTemplate = (DataSource)maybeTemplate.get();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loading template: {}", new Object[]{envelope.templateId()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            SourceTemplateSource source = TemplateSource$.MODULE$.fromSource(templateKey, (Source)Source$.MODULE$.fromInputStream(mustacheTemplate.inputStream(), Codec$.MODULE$.fallbackSystemCodec()));
            Template template = this.engine().load((TemplateSource)source, this.engine().load$default$2());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Processing layout for template: {}", new Object[]{envelope.templateId()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            String output = this.engine().layout(envelope.templateId(), template, envelope.content());
            return output;
        }, this.ec);
    }

    public MustacheTemplateComposer(MustacheComposerConfiguration config, MustacheTemplateRepository mustacheTemplateRepository, ExecutionContext ec) {
        this.mustacheTemplateRepository = mustacheTemplateRepository;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.engine = new TemplateEngine(TemplateEngine$.MODULE$.$lessinit$greater$default$1(), TemplateEngine$.MODULE$.$lessinit$greater$default$2());
        this.engine().workingDirectory_$eq(new File(config.buildDir()));
    }
}

