/*
 * Decompiled with CFR 0.152.
 */
package io.palaima.debugdrawer.commons;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.palaima.debugdrawer.base.DebugModule;
import io.palaima.debugdrawer.commons.R;

public class BuildModule
implements DebugModule {
    private final Context context;
    private TextView codeLabel;
    private TextView nameLabel;
    private TextView packageLabel;

    public BuildModule(Context context) {
        this.context = context;
    }

    @NonNull
    public View onCreateView(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
        View view = inflater.inflate(R.layout.dd_debug_drawer_module_build, parent, false);
        view.setClickable(false);
        view.setEnabled(false);
        this.codeLabel = (TextView)view.findViewById(R.id.dd_debug_build_code);
        this.nameLabel = (TextView)view.findViewById(R.id.dd_debug_build_name);
        this.packageLabel = (TextView)view.findViewById(R.id.dd_debug_build_package);
        this.refresh();
        return view;
    }

    public void onOpened() {
        this.refresh();
    }

    public void onClosed() {
    }

    public void onResume() {
    }

    public void onPause() {
    }

    private void refresh() {
        try {
            PackageInfo info = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            this.codeLabel.setText((CharSequence)String.valueOf(info.versionCode));
            this.nameLabel.setText((CharSequence)info.versionName);
            this.packageLabel.setText((CharSequence)info.packageName);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    public void onStart() {
    }

    public void onStop() {
    }
}

