/*
 * Decompiled with CFR 0.152.
 */
package io.palaima.debugdrawer.commons;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.palaima.debugdrawer.base.DebugModule;
import io.palaima.debugdrawer.commons.R;

public class DeviceModule
implements DebugModule {
    private String deviceMake;
    private String deviceModel;
    private String deviceResolution;
    private String deviceDensity;
    private String deviceRelease;
    private String deviceApi;
    private TextView deviceMakeLabel;
    private TextView deviceModelLabel;
    private TextView deviceResolutionLabel;
    private TextView deviceDensityLabel;
    private TextView deviceReleaseLabel;
    private TextView deviceApiLabel;

    public DeviceModule(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        String densityBucket = DeviceModule.getDensityString(displayMetrics);
        this.deviceMake = DeviceModule.truncateAt(Build.MANUFACTURER, 20);
        this.deviceModel = DeviceModule.truncateAt(Build.MODEL, 20);
        this.deviceResolution = displayMetrics.heightPixels + "x" + displayMetrics.widthPixels;
        this.deviceDensity = displayMetrics.densityDpi + "dpi (" + densityBucket + ")";
        this.deviceRelease = Build.VERSION.RELEASE;
        this.deviceApi = String.valueOf(Build.VERSION.SDK_INT);
    }

    public static String truncateAt(String string, int length) {
        return string.length() > length ? string.substring(0, length) : string;
    }

    private static String getDensityString(DisplayMetrics displayMetrics) {
        switch (displayMetrics.densityDpi) {
            case 120: {
                return "ldpi";
            }
            case 160: {
                return "mdpi";
            }
            case 240: {
                return "hdpi";
            }
            case 320: {
                return "xhdpi";
            }
            case 480: {
                return "xxhdpi";
            }
            case 640: {
                return "xxxhdpi";
            }
            case 213: {
                return "tvdpi";
            }
        }
        return String.valueOf(displayMetrics.densityDpi);
    }

    @NonNull
    public View onCreateView(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
        View view = inflater.inflate(R.layout.dd_debug_drawer_module_device, parent, false);
        view.setClickable(false);
        view.setEnabled(false);
        this.deviceMakeLabel = (TextView)view.findViewById(R.id.dd_debug_device_make);
        this.deviceModelLabel = (TextView)view.findViewById(R.id.dd_debug_device_model);
        this.deviceResolutionLabel = (TextView)view.findViewById(R.id.dd_debug_device_resolution);
        this.deviceDensityLabel = (TextView)view.findViewById(R.id.dd_debug_device_density);
        this.deviceReleaseLabel = (TextView)view.findViewById(R.id.dd_debug_device_release);
        this.deviceApiLabel = (TextView)view.findViewById(R.id.dd_debug_device_api);
        this.deviceModelLabel.setText((CharSequence)this.deviceModel);
        this.deviceMakeLabel.setText((CharSequence)this.deviceMake);
        this.deviceResolutionLabel.setText((CharSequence)this.deviceResolution);
        this.deviceDensityLabel.setText((CharSequence)this.deviceDensity);
        this.deviceApiLabel.setText((CharSequence)this.deviceApi);
        this.deviceReleaseLabel.setText((CharSequence)this.deviceRelease);
        return view;
    }

    public void onOpened() {
    }

    public void onClosed() {
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onStart() {
    }

    public void onStop() {
    }
}

