/*
 * Decompiled with CFR 0.152.
 */
package io.palaima.debugdrawer.commons;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.support.annotation.Nullable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class NetworkController {
    private static NetworkController instance;
    private WifiManager wifiManager;
    private ConnectivityManager connectivityManager;
    private BluetoothAdapter bluetoothAdapter;
    private NetworkReceiver receiver;
    private transient Context context;
    private OnNetworkChangedListener onNetworkChangedListener;

    public static NetworkController newInstance(Context context) {
        if (instance == null) {
            instance = new NetworkController(context);
        }
        return instance;
    }

    private NetworkController(Context context) {
        this.context = context.getApplicationContext();
        this.wifiManager = (WifiManager)this.context.getSystemService("wifi");
        this.connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    public void setOnNetworkChangedListener(OnNetworkChangedListener listener) {
        this.onNetworkChangedListener = listener;
    }

    public boolean isWifiEnabled() {
        return this.wifiManager.isWifiEnabled();
    }

    public void setWifiEnabled(boolean enabled) {
        this.wifiManager.setWifiEnabled(enabled);
    }

    public boolean isMobileNetworkEnabled() {
        NetworkInfo info = this.connectivityManager.getNetworkInfo(0);
        return info != null && info.isConnected();
    }

    public boolean setMobileNetworkEnabled(boolean enabled) {
        try {
            Class<?> conmanClass = Class.forName(this.connectivityManager.getClass().getName());
            Field iConnectivityManagerField = conmanClass.getDeclaredField("mService");
            iConnectivityManagerField.setAccessible(true);
            Object iConnectivityManager = iConnectivityManagerField.get(this.connectivityManager);
            Class<?> iConnectivityManagerClass = Class.forName(iConnectivityManager.getClass().getName());
            Method setMobileDataEnabledMethod = iConnectivityManagerClass.getDeclaredMethod("setMobileDataEnabled", Boolean.TYPE);
            setMobileDataEnabledMethod.setAccessible(true);
            setMobileDataEnabledMethod.invoke(iConnectivityManager, enabled);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return false;
    }

    public boolean isBluetoothAvailable() {
        return this.bluetoothAdapter != null;
    }

    public boolean isBluetoothEnabled() {
        return this.isBluetoothAvailable() && this.hasBlueBoothPermission() && this.bluetoothAdapter.isEnabled();
    }

    private boolean hasBlueBoothPermission() {
        return this.context.checkCallingOrSelfPermission("android.permission.BLUETOOTH") == 0;
    }

    public boolean setBluetoothEnabled(boolean enabled) {
        return this.isBluetoothAvailable() && (enabled ? this.bluetoothAdapter.enable() : this.bluetoothAdapter.disable());
    }

    public void unregisterReceiver() {
        try {
            this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void registerReceiver() {
        if (this.receiver == null) {
            this.receiver = new NetworkReceiver(new Listener(){

                @Override
                public void post(NetworkChangeEvent event) {
                    if (NetworkController.this.onNetworkChangedListener != null) {
                        NetworkController.this.onNetworkChangedListener.onChanged(event);
                    }
                }
            });
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        this.context.registerReceiver((BroadcastReceiver)this.receiver, filter);
    }

    public static interface Listener {
        public void post(NetworkChangeEvent var1);
    }

    public static class NetworkChangeEvent {
        public final NetworkInfo.State wifiState;
        public final NetworkInfo.State mobileState;
        public final BluetoothState bluetoothState;

        public NetworkChangeEvent(NetworkInfo.State wifiState, NetworkInfo.State mobileState, BluetoothState bluetoothState) {
            this.wifiState = wifiState;
            this.mobileState = mobileState;
            this.bluetoothState = bluetoothState;
        }
    }

    public static class NetworkReceiver
    extends BroadcastReceiver {
        @Nullable
        private final Listener listener;

        public NetworkReceiver(@Nullable Listener listener) {
            this.listener = listener;
        }

        public void onReceive(Context context, Intent intent) {
            if (this.listener != null) {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo wifiInfo = connectivityManager.getNetworkInfo(1);
                NetworkInfo mobileInfo = connectivityManager.getNetworkInfo(0);
                BluetoothAdapter bluetoothInfo = BluetoothAdapter.getDefaultAdapter();
                NetworkChangeEvent networkChangeEvent = new NetworkChangeEvent(wifiInfo != null ? wifiInfo.getState() : NetworkInfo.State.UNKNOWN, mobileInfo != null ? mobileInfo.getState() : NetworkInfo.State.UNKNOWN, bluetoothInfo != null ? this.getBluetoothState(bluetoothInfo.getState()) : BluetoothState.Unknown);
                this.listener.post(networkChangeEvent);
            }
        }

        private BluetoothState getBluetoothState(int state) {
            switch (state) {
                case 12: {
                    return BluetoothState.On;
                }
                case 10: {
                    return BluetoothState.Off;
                }
                case 11: {
                    return BluetoothState.Turning_On;
                }
                case 13: {
                    return BluetoothState.Turning_Off;
                }
            }
            return BluetoothState.Unknown;
        }
    }

    public static interface OnNetworkChangedListener {
        public void onChanged(NetworkChangeEvent var1);
    }

    public static enum BluetoothState {
        On,
        Off,
        Turning_On,
        Turning_Off,
        Unknown;

    }
}

