/*
 * Decompiled with CFR 0.152.
 */
package io.palaima.debugdrawer.commons;

import android.content.Context;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.Switch;
import io.palaima.debugdrawer.base.DebugModule;
import io.palaima.debugdrawer.commons.NetworkController;
import io.palaima.debugdrawer.commons.R;

public class NetworkModule
implements DebugModule {
    private final Context context;
    private NetworkController networkController;
    private Switch wifi;
    private Switch mobile;
    private Switch bluetooth;
    private NetworkController.OnNetworkChangedListener onNetworkChangedListener = new NetworkController.OnNetworkChangedListener(){

        @Override
        public void onChanged(NetworkController.NetworkChangeEvent event) {
            if (NetworkModule.this.wifi != null) {
                NetworkModule.this.wifi.setChecked(event.wifiState == NetworkInfo.State.CONNECTED || event.wifiState == NetworkInfo.State.CONNECTING);
            }
            if (NetworkModule.this.mobile != null) {
                NetworkModule.this.mobile.setChecked(event.mobileState == NetworkInfo.State.CONNECTED || event.mobileState == NetworkInfo.State.CONNECTING);
            }
            if (NetworkModule.this.bluetooth != null) {
                NetworkModule.this.bluetooth.setChecked(event.bluetoothState == NetworkController.BluetoothState.On || event.bluetoothState == NetworkController.BluetoothState.Turning_On);
            }
        }
    };

    public NetworkModule(Context context) {
        this.context = context.getApplicationContext();
    }

    @NonNull
    public View onCreateView(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
        View view = inflater.inflate(R.layout.dd_debug_drawer_module_network, parent, false);
        this.wifi = (Switch)view.findViewById(R.id.dd_debug_network_wifi);
        this.mobile = (Switch)view.findViewById(R.id.dd_debug_network_mobile);
        this.mobile.setEnabled(Build.VERSION.SDK_INT < 17);
        this.bluetooth = (Switch)view.findViewById(R.id.dd_debug_network_bluetooth);
        this.networkController = NetworkController.newInstance(this.context);
        this.wifi.setChecked(this.networkController.isWifiEnabled());
        this.wifi.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton button, boolean isChecked) {
                NetworkModule.this.networkController.setWifiEnabled(isChecked);
            }
        });
        this.mobile.setChecked(this.networkController.isMobileNetworkEnabled());
        this.mobile.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton button, boolean isChecked) {
                NetworkModule.this.networkController.setMobileNetworkEnabled(isChecked);
            }
        });
        if (this.networkController.isBluetoothAvailable()) {
            this.bluetooth.setChecked(this.networkController.isBluetoothEnabled());
            this.bluetooth.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton button, boolean isChecked) {
                    NetworkModule.this.networkController.setBluetoothEnabled(isChecked);
                }
            });
        } else {
            this.bluetooth.setEnabled(false);
        }
        return view;
    }

    public void onOpened() {
    }

    public void onClosed() {
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onStop() {
        this.networkController.setOnNetworkChangedListener(null);
        this.networkController.unregisterReceiver();
    }

    public void onStart() {
        this.networkController.setOnNetworkChangedListener(this.onNetworkChangedListener);
        this.networkController.registerReceiver();
    }
}

