/*
 * Decompiled with CFR 0.152.
 */
package io.palaima.debugdrawer.commons;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.Toast;
import io.palaima.debugdrawer.base.DebugModule;
import io.palaima.debugdrawer.commons.R;

public class SettingsModule
implements DebugModule,
View.OnClickListener {
    private final Context context;
    private View developerTitle;
    private ImageView developer;
    private View batteryTitle;
    private ImageView battery;
    private View settingsTitle;
    private ImageView settings;
    private View infoTitle;
    private ImageView info;
    private View uninstallTitle;
    private ImageView uninstall;
    private View locationTitle;
    private ImageView location;

    public SettingsModule(Context context) {
        this.context = context;
    }

    @NonNull
    public View onCreateView(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
        View view = inflater.inflate(R.layout.dd_debug_drawer_module_settings, parent, false);
        view.setClickable(false);
        view.setEnabled(false);
        this.developer = (ImageView)view.findViewById(R.id.dd_debug_settings_developer);
        this.developerTitle = view.findViewById(R.id.dd_debug_settings_developer_title);
        this.battery = (ImageView)view.findViewById(R.id.dd_debug_settings_batery);
        this.batteryTitle = view.findViewById(R.id.dd_debug_settings_batery_title);
        this.settings = (ImageView)view.findViewById(R.id.dd_debug_settings_settings);
        this.settingsTitle = view.findViewById(R.id.dd_debug_settings_settings_title);
        this.info = (ImageView)view.findViewById(R.id.dd_debug_settings_info);
        this.infoTitle = view.findViewById(R.id.dd_debug_settings_info_title);
        this.uninstall = (ImageView)view.findViewById(R.id.dd_debug_settings_delete);
        this.uninstallTitle = view.findViewById(R.id.dd_debug_settings_delete_title);
        this.location = (ImageView)view.findViewById(R.id.dd_debug_location_settings);
        this.locationTitle = view.findViewById(R.id.dd_debug_location_settings_title);
        this.developer.setOnClickListener((View.OnClickListener)this);
        this.developerTitle.setOnClickListener((View.OnClickListener)this);
        this.battery.setOnClickListener((View.OnClickListener)this);
        this.batteryTitle.setOnClickListener((View.OnClickListener)this);
        this.settings.setOnClickListener((View.OnClickListener)this);
        this.settingsTitle.setOnClickListener((View.OnClickListener)this);
        this.info.setOnClickListener((View.OnClickListener)this);
        this.infoTitle.setOnClickListener((View.OnClickListener)this);
        this.uninstall.setOnClickListener((View.OnClickListener)this);
        this.uninstallTitle.setOnClickListener((View.OnClickListener)this);
        this.location.setOnClickListener((View.OnClickListener)this);
        this.locationTitle.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onOpened() {
    }

    public void onClosed() {
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onStart() {
    }

    public void onStop() {
    }

    public void onClick(View v) {
        if (v == this.developer || v == this.developerTitle) {
            Intent devIntent = new Intent("android.settings.APPLICATION_DEVELOPMENT_SETTINGS");
            ResolveInfo resolveInfo = this.context.getPackageManager().resolveActivity(devIntent, 0);
            if (resolveInfo != null) {
                this.context.startActivity(devIntent);
            } else {
                Toast.makeText((Context)this.context, (CharSequence)"Developer settings not available on device", (int)0).show();
            }
        } else if (v == this.battery || v == this.batteryTitle) {
            Intent batteryIntent = new Intent("android.intent.action.POWER_USAGE_SUMMARY");
            ResolveInfo resolveInfo = this.context.getPackageManager().resolveActivity(batteryIntent, 0);
            if (resolveInfo != null) {
                this.context.startActivity(batteryIntent);
            } else {
                Toast.makeText((Context)this.context, (CharSequence)"No app found to handle power usage intent", (int)0).show();
            }
        } else if (v == this.settings || v == this.settingsTitle) {
            this.context.startActivity(new Intent("android.settings.SETTINGS"));
        } else if (v == this.info || v == this.infoTitle) {
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.parse((String)("package:" + this.context.getPackageName())));
            this.context.startActivity(intent);
        } else if (v == this.uninstall || v == this.uninstallTitle) {
            Uri packageURI = Uri.parse((String)("package:" + this.context.getPackageName()));
            Intent uninstallIntent = new Intent("android.intent.action.DELETE", packageURI);
            this.context.startActivity(uninstallIntent);
        } else if (v == this.location || v == this.locationTitle) {
            this.context.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS"));
        }
    }
}

