/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.spring.reactive;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.result.view.AbstractUrlBasedView;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PebbleReactiveView
extends AbstractUrlBasedView {
    private PebbleEngine pebbleEngine;
    private String templateName;

    public boolean checkResourceExists(Locale locale) {
        return this.pebbleEngine.getLoader().resourceExists(this.templateName);
    }

    protected Mono<Void> renderInternal(Map<String, Object> renderAttributes, MediaType contentType, ServerWebExchange exchange) {
        DataBuffer dataBuffer = exchange.getResponse().bufferFactory().allocateBuffer();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(exchange.getLogPrefix() + "Rendering [" + this.getUrl() + "]"));
        }
        Locale locale = LocaleContextHolder.getLocale((LocaleContext)exchange.getLocaleContext());
        try {
            Charset charset = this.getCharset(contentType);
            OutputStreamWriter writer = new OutputStreamWriter(dataBuffer.asOutputStream(), charset);
            this.evaluateTemplate(renderAttributes, locale, writer);
        }
        catch (Exception ex) {
            DataBufferUtils.release((DataBuffer)dataBuffer);
            return Mono.error((Throwable)ex);
        }
        return exchange.getResponse().writeWith((Publisher)Flux.just((Object)dataBuffer));
    }

    private Charset getCharset(@Nullable MediaType mediaType) {
        return Optional.ofNullable(mediaType).map(MimeType::getCharset).orElse(this.getDefaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateTemplate(Map<String, Object> model, Locale locale, Writer writer) throws IOException, PebbleException {
        try {
            PebbleTemplate template = this.pebbleEngine.getTemplate(this.templateName);
            template.evaluate(writer, model, locale);
        }
        finally {
            writer.flush();
        }
    }

    public PebbleEngine getPebbleEngine() {
        return this.pebbleEngine;
    }

    public void setPebbleEngine(PebbleEngine pebbleEngine) {
        this.pebbleEngine = pebbleEngine;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }
}

