/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.spring.servlet;

import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.loader.Loader;
import io.pebbletemplates.spring.servlet.PebbleView;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class PebbleViewResolver
extends AbstractTemplateViewResolver
implements InitializingBean {
    private String characterEncoding = "UTF-8";
    private final PebbleEngine pebbleEngine;

    public PebbleViewResolver(PebbleEngine pebbleEngine) {
        this.pebbleEngine = pebbleEngine;
        this.setViewClass(this.requiredViewClass());
    }

    public void afterPropertiesSet() {
        Loader templateLoader = this.pebbleEngine.getLoader();
        templateLoader.setPrefix(this.getPrefix());
        templateLoader.setSuffix(this.getSuffix());
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        PebbleView view = (PebbleView)super.buildView(viewName);
        view.setTemplateName(viewName);
        view.setPebbleEngine(this.pebbleEngine);
        view.setCharacterEncoding(this.characterEncoding);
        return view;
    }

    protected Class<?> requiredViewClass() {
        return PebbleView.class;
    }
}

