/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node.expression;

import com.mitchellbosecke.pebble.error.AttributeNotFoundException;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Test;
import com.mitchellbosecke.pebble.extension.core.DefinedTest;
import com.mitchellbosecke.pebble.node.ArgumentsNode;
import com.mitchellbosecke.pebble.node.TestInvocationExpression;
import com.mitchellbosecke.pebble.node.expression.BinaryExpression;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.util.Map;

public class PositiveTestExpression
extends BinaryExpression<Object> {
    private Test cachedTest;

    @Override
    public Object evaluate(PebbleTemplateImpl self, EvaluationContext context) {
        TestInvocationExpression testInvocation = (TestInvocationExpression)this.getRightExpression();
        ArgumentsNode args = testInvocation.getArgs();
        if (this.cachedTest == null) {
            String testName = testInvocation.getTestName();
            this.cachedTest = context.getExtensionRegistry().getTest(testInvocation.getTestName());
            if (this.cachedTest == null) {
                throw new PebbleException(null, String.format("Test [%s] does not exist.", testName), this.getLineNumber(), self.getName());
            }
        }
        Test test = this.cachedTest;
        Map<String, Object> namedArguments = args.getArgumentMap(self, context, test);
        if (test instanceof DefinedTest) {
            Object input = null;
            try {
                input = this.getLeftExpression().evaluate(self, context);
            }
            catch (AttributeNotFoundException e) {
                input = null;
            }
            return test.apply(input, namedArguments);
        }
        return test.apply(this.getLeftExpression().evaluate(self, context), namedArguments);
    }
}

