/*******************************************************************************
 * This file is part of Pebble.
 *
 * Copyright (c) 2014 by Mitchell Bösecke
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 ******************************************************************************/
package com.mitchellbosecke.pebble.node.expression;

import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.template.EvaluationContextImpl;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;

public class LiteralIntegerExpression implements Expression<Integer> {

  private final Integer value;
  private final int lineNumber;

  public LiteralIntegerExpression(Integer value, int lineNumber) {
    this.value = value;
    this.lineNumber = lineNumber;
  }

  @Override
  public void accept(NodeVisitor visitor) {
    visitor.visit(this);
  }

  @Override
  public Integer evaluate(PebbleTemplateImpl self, EvaluationContextImpl context) {
    return value;
  }

  @Override
  public int getLineNumber() {
    return this.lineNumber;
  }

}
