/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.attributes;

import com.mitchellbosecke.pebble.attributes.AttributeResolver;
import com.mitchellbosecke.pebble.attributes.ResolvedAttribute;
import com.mitchellbosecke.pebble.error.AttributeNotFoundException;
import com.mitchellbosecke.pebble.node.ArgumentsNode;
import com.mitchellbosecke.pebble.template.EvaluationContextImpl;
import java.util.List;

public class ListResolver
implements AttributeResolver {
    static final ListResolver INSTANCE = new ListResolver();

    private ListResolver() {
    }

    @Override
    public ResolvedAttribute resolve(Object instance, Object attributeNameValue, Object[] argumentValues, ArgumentsNode args, EvaluationContextImpl context, String filename, int lineNumber) {
        String attributeName = String.valueOf(attributeNameValue);
        List list = (List)instance;
        int index = this.getIndex(attributeName);
        int length = list.size();
        if (index < 0 || index >= length) {
            if (context.isStrictVariables()) {
                throw new AttributeNotFoundException(null, "Index out of bounds while accessing array with strict variables on.", attributeName, lineNumber, filename);
            }
            return new ResolvedAttribute(null);
        }
        return new ResolvedAttribute(list.get(index));
    }

    private int getIndex(String attributeName) {
        try {
            return Integer.parseInt(attributeName);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

