/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.attributes;

import com.mitchellbosecke.pebble.error.ClassAccessException;
import com.mitchellbosecke.pebble.template.EvaluationContextImpl;
import com.mitchellbosecke.pebble.template.EvaluationOptions;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class MemberCacheUtils {
    private final ConcurrentHashMap<MemberCacheKey, Member> memberCache = new ConcurrentHashMap(100, 0.9f, 1);

    Member getMember(Object instance, String attributeName) {
        return this.memberCache.get(new MemberCacheKey(instance.getClass(), attributeName));
    }

    Member cacheMember(Object instance, String attributeName, Object[] argumentValues, EvaluationContextImpl context, String filename, int lineNumber) {
        if (argumentValues == null) {
            argumentValues = new Object[]{};
        }
        Class[] argumentTypes = new Class[argumentValues.length];
        for (int i = 0; i < argumentValues.length; ++i) {
            Object o = argumentValues[i];
            argumentTypes[i] = o == null ? null : o.getClass();
        }
        Member member = this.reflect(instance, attributeName, argumentTypes, filename, lineNumber, context.getEvaluationOptions());
        if (member != null) {
            this.memberCache.put(new MemberCacheKey(instance.getClass(), attributeName), member);
        }
        return member;
    }

    private Member reflect(Object object, String attributeName, Class<?>[] parameterTypes, String filename, int lineNumber, EvaluationOptions evaluationOptions) {
        Class<?> clazz = object.getClass();
        String attributeCapitalized = Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1);
        AccessibleObject result = this.findMethod(clazz, "get" + attributeCapitalized, parameterTypes, filename, lineNumber, evaluationOptions);
        if (result == null) {
            result = this.findMethod(clazz, "is" + attributeCapitalized, parameterTypes, filename, lineNumber, evaluationOptions);
        }
        if (result == null) {
            result = this.findMethod(clazz, "has" + attributeCapitalized, parameterTypes, filename, lineNumber, evaluationOptions);
        }
        if (result == null) {
            result = this.findMethod(clazz, attributeName, parameterTypes, filename, lineNumber, evaluationOptions);
        }
        if (result == null) {
            try {
                result = clazz.getField(attributeName);
            }
            catch (NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        if (result != null) {
            ((AccessibleObject)result).setAccessible(true);
        }
        return result;
    }

    private Method findMethod(Class<?> clazz, String name, Class<?>[] requiredTypes, String filename, int lineNumber, EvaluationOptions evaluationOptions) {
        int i;
        Class<?>[] types;
        boolean compatibleTypes;
        if (!evaluationOptions.isAllowGetClass() && name.equals("getClass")) {
            throw new ClassAccessException(lineNumber, filename);
        }
        List<Method> candidates = this.getCandidates(clazz, name, requiredTypes);
        for (Method candidate : candidates) {
            compatibleTypes = true;
            types = candidate.getParameterTypes();
            for (i = 0; i < types.length; ++i) {
                if (requiredTypes[i] == null || this.widen(types[i]).isAssignableFrom(requiredTypes[i])) continue;
                compatibleTypes = false;
                break;
            }
            if (!compatibleTypes) continue;
            return candidate;
        }
        if (evaluationOptions.isGreedyMatchMethod()) {
            for (Method candidate : candidates) {
                compatibleTypes = true;
                types = candidate.getParameterTypes();
                for (i = 0; i < types.length; ++i) {
                    if (requiredTypes[i] == null || this.isCompatibleType(types[i], requiredTypes[i])) continue;
                    compatibleTypes = false;
                    break;
                }
                if (!compatibleTypes) continue;
                return candidate;
            }
        }
        return null;
    }

    private Class<?> widen(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }

    private List<Method> getCandidates(Class<?> clazz, String name, Object[] requiredTypes) {
        Method[] methods;
        ArrayList<Method> candidates = new ArrayList<Method>();
        for (Method m : methods = clazz.getMethods()) {
            Class<?>[] types;
            if (!m.getName().equalsIgnoreCase(name) || (types = m.getParameterTypes()).length != requiredTypes.length) continue;
            candidates.add(m);
        }
        return candidates;
    }

    private boolean isCompatibleType(Class<?> type1, Class<?> type2) {
        Class<?> widenType = this.widen(type1);
        return Number.class.isAssignableFrom(widenType) && Number.class.isAssignableFrom(type2);
    }

    private class MemberCacheKey {
        private final Class<?> clazz;
        private final String attributeName;

        private MemberCacheKey(Class<?> clazz, String attributeName) {
            this.clazz = clazz;
            this.attributeName = attributeName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberCacheKey that = (MemberCacheKey)o;
            if (!this.clazz.equals(that.clazz)) {
                return false;
            }
            return this.attributeName.equals(that.attributeName);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.attributeName.hashCode();
            return result;
        }
    }
}

