/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.node.AbstractRenderableNode;
import com.mitchellbosecke.pebble.node.BodyNode;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.template.EvaluationContextImpl;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import com.mitchellbosecke.pebble.template.ScopeChain;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ForNode
extends AbstractRenderableNode {
    private final String variableName;
    private final Expression<?> iterableExpression;
    private final BodyNode body;
    private final BodyNode elseBody;

    public ForNode(int lineNumber, String variableName, Expression<?> iterableExpression, BodyNode body, BodyNode elseBody) {
        super(lineNumber);
        this.variableName = variableName;
        this.iterableExpression = iterableExpression;
        this.body = body;
        this.elseBody = elseBody;
    }

    @Override
    public void render(PebbleTemplateImpl self, Writer writer, EvaluationContextImpl context) throws IOException {
        final Object iterableEvaluation = this.iterableExpression.evaluate(self, context);
        if (iterableEvaluation == null) {
            return;
        }
        Iterable<Object> iterable = this.toIterable(iterableEvaluation);
        if (iterable == null) {
            throw new PebbleException(null, "Not an iterable object. Value = [" + iterableEvaluation.toString() + "]", this.getLineNumber(), self.getName());
        }
        Iterator<Object> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            boolean usingExecutorService;
            ScopeChain scopeChain = context.getScopeChain();
            scopeChain.pushScope();
            final Control length = new Control(){

                public String toString() {
                    if (this.value == -1) {
                        this.value = ForNode.this.getIteratorSize(iterableEvaluation);
                    }
                    return String.valueOf(this.value);
                }
            };
            int index = 0;
            HashMap<String, Object> loop = null;
            boolean bl = usingExecutorService = context.getExecutorService() != null;
            while (iterator.hasNext()) {
                if (index == 0 || usingExecutorService) {
                    loop = new HashMap<String, Object>();
                    loop.put("first", index == 0);
                    loop.put("last", !iterator.hasNext());
                    loop.put("length", length);
                } else if (index == 1) {
                    loop.put("first", false);
                }
                Control revindex = new Control(index){

                    public String toString() {
                        return String.valueOf(Integer.valueOf(length.toString()) - this.value - 1);
                    }
                };
                loop.put("revindex", revindex);
                loop.put("index", index++);
                scopeChain.put("loop", loop);
                scopeChain.put(this.variableName, iterator.next());
                if (!iterator.hasNext()) {
                    loop.put("last", true);
                }
                this.body.render(self, writer, context);
            }
            scopeChain.popScope();
        } else if (this.elseBody != null) {
            this.elseBody.render(self, writer, context);
        }
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public String getIterationVariable() {
        return this.variableName;
    }

    public Expression<?> getIterable() {
        return this.iterableExpression;
    }

    public BodyNode getBody() {
        return this.body;
    }

    public BodyNode getElseBody() {
        return this.elseBody;
    }

    private Iterable<Object> toIterable(Object obj) {
        Iterable result = null;
        if (obj instanceof Iterable) {
            result = (Set)obj;
        } else if (obj instanceof Map) {
            result = ((Map)obj).entrySet();
        } else if (obj.getClass().isArray()) {
            result = new ArrayIterable(obj);
        } else if (obj instanceof Enumeration) {
            result = new EnumerationIterable((Enumeration)obj);
        }
        return result;
    }

    private int getIteratorSize(Object iterable) {
        if (iterable == null) {
            return 0;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        if (iterable instanceof Map) {
            return ((Map)iterable).size();
        }
        if (iterable.getClass().isArray()) {
            return Array.getLength(iterable);
        }
        if (iterable instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)iterable;
            int size = 0;
            while (enumeration.hasMoreElements()) {
                ++size;
                enumeration.nextElement();
            }
            return size;
        }
        Iterator it = ((Iterable)iterable).iterator();
        int size = 0;
        while (it.hasNext()) {
            ++size;
            it.next();
        }
        return size;
    }

    private class EnumerationIterable
    implements Iterable<Object> {
        private Enumeration<Object> obj;

        public EnumerationIterable(Enumeration<Object> enumeration) {
            this.obj = enumeration;
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return EnumerationIterable.this.obj.hasMoreElements();
                }

                @Override
                public Object next() {
                    return EnumerationIterable.this.obj.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private class ArrayIterable
    implements Iterable<Object> {
        private Object obj;

        public ArrayIterable(Object array) {
            this.obj = array;
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                private int index = 0;
                private final int length = Array.getLength(ArrayIterable.access$100(ArrayIterable.this));

                @Override
                public boolean hasNext() {
                    return this.index < this.length;
                }

                @Override
                public Object next() {
                    return Array.get(ArrayIterable.this.obj, this.index++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class Control {
        protected int value = -1;

        public Control(int value) {
            this.value = value;
        }

        public Control() {
        }
    }
}

