/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.extension.escaper;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.escaper.EscapingStrategy;
import com.mitchellbosecke.pebble.extension.escaper.SafeString;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import com.mitchellbosecke.pebble.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unbescape.css.CssEscape;
import org.unbescape.html.HtmlEscape;
import org.unbescape.javascript.JavaScriptEscape;
import org.unbescape.uri.UriEscape;

public class EscapeFilter
implements Filter {
    private String defaultStrategy = "html";
    private final List<String> argumentNames = new ArrayList<String>();
    private final Map<String, EscapingStrategy> strategies = new HashMap<String, EscapingStrategy>();

    public EscapeFilter() {
        this.buildDefaultStrategies();
        this.argumentNames.add("strategy");
    }

    private void buildDefaultStrategies() {
        this.strategies.put("html", HtmlEscape::escapeHtml4Xml);
        this.strategies.put("js", JavaScriptEscape::escapeJavaScript);
        this.strategies.put("css", CssEscape::escapeCssIdentifier);
        this.strategies.put("url_param", UriEscape::escapeUriQueryParam);
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Object apply(Object inputObject, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (inputObject == null || inputObject instanceof SafeString) {
            return inputObject;
        }
        String input = StringUtils.toString(inputObject);
        String strategy = this.defaultStrategy;
        if (args.get("strategy") != null) {
            strategy = (String)args.get("strategy");
        }
        if (!this.strategies.containsKey(strategy)) {
            throw new PebbleException(null, String.format("Unknown escaping strategy [%s]", strategy), lineNumber, self.getName());
        }
        return new SafeString(this.strategies.get(strategy).escape(input));
    }

    public String getDefaultStrategy() {
        return this.defaultStrategy;
    }

    public void setDefaultStrategy(String defaultStrategy) {
        this.defaultStrategy = defaultStrategy;
    }

    public void addEscapingStrategy(String name, EscapingStrategy strategy) {
        this.strategies.put(name, strategy);
    }
}

