/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.operator;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.node.expression.BinaryExpression;
import com.mitchellbosecke.pebble.node.expression.FilterExpression;
import com.mitchellbosecke.pebble.node.expression.NegativeTestExpression;
import com.mitchellbosecke.pebble.node.expression.PositiveTestExpression;
import com.mitchellbosecke.pebble.operator.Associativity;
import com.mitchellbosecke.pebble.operator.BinaryOperator;
import com.mitchellbosecke.pebble.operator.BinaryOperatorType;
import java.util.function.Supplier;

public class BinaryOperatorImpl
implements BinaryOperator {
    private final int precedence;
    private final String symbol;
    private final Supplier<? extends BinaryExpression<?>> nodeSupplier;
    private final BinaryOperatorType type;
    private final Associativity associativity;

    public BinaryOperatorImpl(String symbol, int precedence, Class<? extends BinaryExpression<?>> nodeClass, Associativity associativity) {
        this(symbol, precedence, () -> {
            try {
                return (BinaryExpression)nodeClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new PebbleException(e, "Error instantiating class " + nodeClass.getName());
            }
        }, BinaryOperatorImpl.getDefaultType(nodeClass), associativity);
    }

    public BinaryOperatorImpl(String symbol, int precedence, Supplier<? extends BinaryExpression<?>> nodeSupplier, BinaryOperatorType type, Associativity associativity) {
        this.symbol = symbol;
        this.precedence = precedence;
        this.nodeSupplier = nodeSupplier;
        this.type = type;
        this.associativity = associativity;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public BinaryExpression<?> getInstance() {
        return this.nodeSupplier.get();
    }

    @Override
    public BinaryOperatorType getType() {
        return this.type;
    }

    @Override
    public Associativity getAssociativity() {
        return this.associativity;
    }

    private static BinaryOperatorType getDefaultType(Class<? extends BinaryExpression<?>> nodeClass) {
        if (FilterExpression.class.equals(nodeClass)) {
            return BinaryOperatorType.FILTER;
        }
        if (PositiveTestExpression.class.equals(nodeClass) || NegativeTestExpression.class.equals(nodeClass)) {
            return BinaryOperatorType.TEST;
        }
        return BinaryOperatorType.NORMAL;
    }
}

