/*
 * Decompiled with CFR 0.152.
 */
package io.percy.selenium;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.WrapsDriver;

class Environment {
    private static final String PROPS_PATH = "META-INF/maven/io.percy.selenium/percy-java-selenium/pom.properties";
    private static final String DEFAULT_ARTIFACTID = "percy-java-selenium";
    private static final String UNKNOWN_VERSION = "unknown";
    private WebDriver driver;

    Environment(WebDriver driver) {
        this.driver = driver;
    }

    public String getClientInfo() {
        String artifactId = DEFAULT_ARTIFACTID;
        String version = UNKNOWN_VERSION;
        InputStream propsStream = this.getClass().getClassLoader().getResourceAsStream(PROPS_PATH);
        if (propsStream != null) {
            try (InputStreamReader streamReader = new InputStreamReader(propsStream);
                 BufferedReader reader = new BufferedReader(streamReader);){
                while (reader.ready()) {
                    String line = reader.readLine();
                    String[] lineParts = line.split("=");
                    if (lineParts.length != 2) continue;
                    if (lineParts[0].equals("version")) {
                        version = lineParts[1];
                        continue;
                    }
                    if (!lineParts[0].equals("artifactId")) continue;
                    artifactId = lineParts[1];
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return String.format("%s/%s", artifactId, version);
    }

    public String getEnvironmentInfo() {
        WebDriver innerDriver;
        WebDriver webDriver = innerDriver = this.driver instanceof WrapsDriver ? ((WrapsDriver)this.driver).getWrappedDriver() : this.driver;
        if (innerDriver instanceof HasCapabilities) {
            Capabilities cap = ((HasCapabilities)this.driver).getCapabilities();
            String os = cap.getPlatform().toString();
            String browserName = cap.getBrowserName().toLowerCase();
            String version = cap.getVersion().toString();
            return String.format("selenium-java; %s; %s/%s", os, browserName, version);
        }
        return String.format("selenium-java; unknownDriver; %s", innerDriver.getClass().getName());
    }
}

