/*
 * Decompiled with CFR 0.152.
 */
package io.percy.selenium;

import io.percy.selenium.Environment;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class Percy {
    private static final Logger LOGGER = Logger.getLogger(Percy.class.getName());
    private static final String AGENTJS_FILE = "percy-agent.js";
    private WebDriver driver;
    private String percyAgentJs;
    private Environment env;
    private boolean percyIsRunning = true;

    public Percy(WebDriver driver) {
        this.driver = driver;
        this.env = new Environment(driver);
        this.percyAgentJs = this.loadPercyAgentJs();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String loadPercyAgentJs() {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            String agentJSString;
            HttpGet httpget = new HttpGet("http://localhost:5338/percy-agent.js");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new RuntimeException("Failed with HTTP error code : " + statusCode);
            }
            HttpEntity httpEntity = response.getEntity();
            String string = agentJSString = EntityUtils.toString((HttpEntity)httpEntity);
            return string;
        }
        catch (Exception ex) {
            System.out.println("[percy] An error occured while retrieving percy-agent.js: " + ex);
            this.percyIsRunning = false;
            System.out.println("[percy] Percy has been disabled");
            return null;
        }
    }

    public void snapshot(String name) {
        this.snapshot(name, null, null, false, null);
    }

    public void snapshot(String name, List<Integer> widths) {
        this.snapshot(name, widths, null, false, null);
    }

    public void snapshot(String name, List<Integer> widths, Integer minHeight) {
        this.snapshot(name, widths, minHeight, false, null);
    }

    public void snapshot(String name, List<Integer> widths, Integer minHeight, boolean enableJavaScript) {
        this.snapshot(name, widths, minHeight, enableJavaScript, null);
    }

    public void snapshot(String name, @Nullable List<Integer> widths, Integer minHeight, boolean enableJavaScript, String percyCSS) {
        String domSnapshot = "";
        if (this.percyAgentJs == null) {
            return;
        }
        try {
            JavascriptExecutor jse = (JavascriptExecutor)this.driver;
            jse.executeScript(this.percyAgentJs, new Object[0]);
            domSnapshot = (String)jse.executeScript(this.buildSnapshotJS(), new Object[0]);
        }
        catch (WebDriverException e) {
            System.out.println("[percy] Something went wrong attempting to take a snapshot: " + e.getMessage());
        }
        this.postSnapshot(domSnapshot, name, widths, minHeight, this.driver.getCurrentUrl(), enableJavaScript, percyCSS);
    }

    private void postSnapshot(String domSnapshot, String name, @Nullable List<Integer> widths, Integer minHeight, String url, boolean enableJavaScript, String percyCSS) {
        if (!this.percyIsRunning) {
            return;
        }
        JSONObject json = new JSONObject();
        json.put("url", (Object)url);
        json.put("name", (Object)name);
        json.put("percyCSS", (Object)percyCSS);
        json.put("minHeight", (Object)minHeight);
        json.put("domSnapshot", (Object)domSnapshot);
        json.put("clientInfo", (Object)this.env.getClientInfo());
        json.put("enableJavaScript", enableJavaScript);
        json.put("environmentInfo", (Object)this.env.getEnvironmentInfo());
        if (widths != null && widths.size() != 0) {
            json.put("widths", widths);
        }
        StringEntity entity = new StringEntity(json.toString(), ContentType.APPLICATION_JSON);
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            HttpPost request = new HttpPost("http://localhost:5338/percy/snapshot");
            request.setEntity((HttpEntity)entity);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)request);
        }
        catch (Exception ex) {
            System.out.println("[percy] An error occured when sending the DOM to agent: " + ex);
            this.percyIsRunning = false;
            System.out.println("[percy] Percy has been disabled");
        }
    }

    private String getAgentOptions() {
        StringBuilder info = new StringBuilder();
        info.append("{ ");
        info.append(String.format("handleAgentCommunication: false", new Object[0]));
        info.append(" }");
        return info.toString();
    }

    private String buildSnapshotJS() {
        StringBuilder jsBuilder = new StringBuilder();
        jsBuilder.append(String.format("var percyAgentClient = new PercyAgent(%s)\n", this.getAgentOptions()));
        jsBuilder.append(String.format("return percyAgentClient.snapshot('not used')", new Object[0]));
        return jsBuilder.toString();
    }
}

