/*
 * Decompiled with CFR 0.152.
 */
package io.percy.selenium;

import io.percy.selenium.Environment;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class Percy {
    private WebDriver driver;
    private String domJs = "";
    private String PERCY_SERVER_ADDRESS = System.getenv().getOrDefault("PERCY_SERVER_ADDRESS", "http://localhost:5338");
    private boolean PERCY_DEBUG = System.getenv().getOrDefault("PERCY_LOGLEVEL", "info").equals("debug");
    private String LABEL = "[\u001b[35m" + (this.PERCY_DEBUG ? "percy:java" : "percy") + "\u001b[39m]";
    private boolean isPercyEnabled = this.healthcheck();
    private Environment env;

    public Percy(WebDriver driver) {
        this.driver = driver;
        this.env = new Environment(driver);
    }

    public void snapshot(String name) {
        this.snapshot(name, null, null, false, null, null);
    }

    public void snapshot(String name, List<Integer> widths) {
        this.snapshot(name, widths, null, false, null, null);
    }

    public void snapshot(String name, List<Integer> widths, Integer minHeight) {
        this.snapshot(name, widths, minHeight, false, null, null);
    }

    public void snapshot(String name, List<Integer> widths, Integer minHeight, boolean enableJavaScript) {
        this.snapshot(name, widths, minHeight, enableJavaScript, null, null);
    }

    public void snapshot(String name, @Nullable List<Integer> widths, Integer minHeight, boolean enableJavaScript, String percyCSS) {
        this.snapshot(name, widths, minHeight, enableJavaScript, percyCSS, null);
    }

    public void snapshot(String name, @Nullable List<Integer> widths, Integer minHeight, boolean enableJavaScript, String percyCSS, String scope) {
        Map domSnapshot;
        block3: {
            if (!this.isPercyEnabled) {
                return;
            }
            domSnapshot = null;
            try {
                JavascriptExecutor jse = (JavascriptExecutor)this.driver;
                jse.executeScript(this.fetchPercyDOM(), new Object[0]);
                domSnapshot = (Map)jse.executeScript(this.buildSnapshotJS(Boolean.toString(enableJavaScript)), new Object[0]);
            }
            catch (WebDriverException e) {
                if (!this.PERCY_DEBUG) break block3;
                this.log(e.getMessage());
            }
        }
        this.postSnapshot(domSnapshot, name, widths, minHeight, this.driver.getCurrentUrl(), enableJavaScript, percyCSS, scope);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean healthcheck() {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            HttpGet httpget = new HttpGet(this.PERCY_SERVER_ADDRESS + "/percy/healthcheck");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new RuntimeException("Failed with HTTP error code : " + statusCode);
            }
            String version = response.getFirstHeader("x-percy-core-version").getValue();
            if (version == null) {
                this.log("You may be using @percy/agentwhich is no longer supported by this SDK.Please uninstall @percy/agent and install @percy/cli instead.https://docs.percy.io/docs/migrating-to-percy-cli");
                boolean bl = false;
                return bl;
            }
            if (!version.split("\\.")[0].equals("1")) {
                this.log("Unsupported Percy CLI version, " + version);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            this.log("Percy is not running, disabling snapshots");
            if (!this.PERCY_DEBUG) return false;
            this.log(ex.toString());
            return false;
        }
    }

    private String fetchPercyDOM() {
        String string;
        block11: {
            if (!this.domJs.trim().isEmpty()) {
                return this.domJs;
            }
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            try {
                String domString;
                HttpGet httpget = new HttpGet(this.PERCY_SERVER_ADDRESS + "/percy/dom.js");
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new RuntimeException("Failed with HTTP error code: " + statusCode);
                }
                HttpEntity httpEntity = response.getEntity();
                this.domJs = domString = EntityUtils.toString((HttpEntity)httpEntity);
                string = domString;
                if (httpClient == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    this.isPercyEnabled = false;
                    if (this.PERCY_DEBUG) {
                        this.log(ex.toString());
                    }
                    return "";
                }
            }
            httpClient.close();
        }
        return string;
    }

    private void postSnapshot(Map<String, Object> domSnapshot, String name, @Nullable List<Integer> widths, Integer minHeight, String url, boolean enableJavaScript, String percyCSS, String scope) {
        if (!this.isPercyEnabled) {
            return;
        }
        JSONObject json = new JSONObject();
        json.put("url", (Object)url);
        json.put("name", (Object)name);
        json.put("scope", (Object)scope);
        json.put("percyCSS", (Object)percyCSS);
        json.put("minHeight", (Object)minHeight);
        json.put("domSnapshot", domSnapshot);
        json.put("clientInfo", (Object)this.env.getClientInfo());
        json.put("enableJavaScript", enableJavaScript);
        json.put("environmentInfo", (Object)this.env.getEnvironmentInfo());
        json.put("widths", widths);
        StringEntity entity = new StringEntity(json.toString(), ContentType.APPLICATION_JSON);
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            HttpPost request = new HttpPost(this.PERCY_SERVER_ADDRESS + "/percy/snapshot");
            request.setEntity((HttpEntity)entity);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)request);
        }
        catch (Exception ex) {
            if (this.PERCY_DEBUG) {
                this.log(ex.toString());
            }
            this.log("Could not post snapshot " + name);
        }
    }

    private String buildSnapshotJS(String enableJavaScript) {
        StringBuilder jsBuilder = new StringBuilder();
        jsBuilder.append(String.format("return PercyDOM.serialize({ enableJavaScript: %s })\n", enableJavaScript));
        return jsBuilder.toString();
    }

    private void log(String message) {
        System.out.println(this.LABEL + " " + message);
    }
}

