/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler;

import io.perfana.eventscheduler.api.CustomEvent;
import io.perfana.eventscheduler.api.EventCheck;
import io.perfana.eventscheduler.api.EventLogger;
import io.perfana.eventscheduler.exception.EventSchedulerRuntimeException;
import io.perfana.eventscheduler.exception.handler.AbortSchedulerException;
import io.perfana.eventscheduler.exception.handler.KillSwitchException;
import io.perfana.eventscheduler.exception.handler.StopTestRunException;
import java.util.List;
import java.util.Queue;

public interface EventBroadcaster {
    public void broadcastBeforeTest();

    public void broadcastStartTest();

    public void broadcastAfterTest();

    public void broadcastKeepAlive();

    public void broadcastAbortTest();

    public void broadcastCustomEvent(CustomEvent var1);

    public List<EventCheck> broadcastCheck();

    public void shutdownAndWaitAllTasksDone(long var1);

    default public void throwAbortOrKillWitchOrStopTestRunException(Queue<Throwable> exceptions, int stopTestExceptionCount, EventLogger logger) {
        exceptions.stream().filter(AbortSchedulerException.class::isInstance).findFirst().ifPresent(abort -> {
            throw new AbortSchedulerException("Found abort scheduler request during keep-alive broadcast: " + abort.getMessage());
        });
        exceptions.stream().filter(KillSwitchException.class::isInstance).findFirst().ifPresent(kill -> {
            throw new KillSwitchException("Found kill switch request during keep-alive broadcast: " + kill.getMessage());
        });
        long currentStopRunExceptionCount = exceptions.stream().filter(StopTestRunException.class::isInstance).count();
        if (stopTestExceptionCount > 0) {
            logger.info("Found " + currentStopRunExceptionCount + " of expected " + stopTestExceptionCount + " stop run exceptions.");
            if (currentStopRunExceptionCount == (long)stopTestExceptionCount) {
                throw new StopTestRunException("Found " + currentStopRunExceptionCount + " stop run exceptions.");
            }
            if (currentStopRunExceptionCount > (long)stopTestExceptionCount) {
                throw new EventSchedulerRuntimeException("More StopTestRunExceptions received (" + currentStopRunExceptionCount + "/" + stopTestExceptionCount + ") than expected, check your config. Are events throwing StopTestRunExceptions while not a ContinueOnKeepAlive participant?");
            }
        }
    }
}

