/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler;

import io.perfana.eventscheduler.EventBroadcaster;
import io.perfana.eventscheduler.EventSchedulerEngine;
import io.perfana.eventscheduler.api.CustomEvent;
import io.perfana.eventscheduler.api.EventCheck;
import io.perfana.eventscheduler.api.EventLogger;
import io.perfana.eventscheduler.api.EventStatus;
import io.perfana.eventscheduler.api.SchedulerExceptionHandler;
import io.perfana.eventscheduler.api.config.EventContext;
import io.perfana.eventscheduler.api.config.EventSchedulerContext;
import io.perfana.eventscheduler.api.config.TestContext;
import io.perfana.eventscheduler.api.message.EventMessage;
import io.perfana.eventscheduler.api.message.EventMessageBus;
import io.perfana.eventscheduler.exception.EventCheckFailureException;
import io.perfana.eventscheduler.util.TestRunConfigUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public final class EventScheduler {
    private final EventLogger logger;
    private final String name;
    private final boolean checkResultsEnabled;
    private final EventBroadcaster broadcaster;
    private final EventMessageBus messageBus;
    private final Collection<CustomEvent> scheduleEvents;
    private final EventSchedulerContext eventSchedulerContext;
    private final AtomicReference<SchedulerExceptionHandler> schedulerExceptionHandler = new AtomicReference();
    private final EventSchedulerEngine eventSchedulerEngine;
    private final AtomicBoolean isSessionActive = new AtomicBoolean(false);
    private final AtomicInteger goMessageCount = new AtomicInteger(0);
    private final StartTestFunction startTestFunction;
    private final int waitForGoMessagesCount;

    EventScheduler(EventBroadcaster broadcaster, Collection<CustomEvent> scheduleEvents, EventSchedulerContext eventSchedulerContext, EventMessageBus messageBus, EventLogger logger, EventSchedulerEngine eventSchedulerEngine, SchedulerExceptionHandler schedulerExceptionHandler) {
        this.name = eventSchedulerContext.getTestContext().getTestRunId();
        this.broadcaster = broadcaster;
        this.eventSchedulerContext = eventSchedulerContext;
        this.checkResultsEnabled = eventSchedulerContext.isSchedulerEnabled();
        this.scheduleEvents = scheduleEvents;
        this.logger = logger;
        this.eventSchedulerEngine = eventSchedulerEngine;
        this.schedulerExceptionHandler.set(schedulerExceptionHandler);
        this.messageBus = messageBus;
        this.waitForGoMessagesCount = (int)eventSchedulerContext.getEventContexts().stream().filter(EventContext::isReadyForStartParticipant).peek(e -> logger.info("Found 'ReadyForStart' participant: " + e.getName())).count();
        eventSchedulerContext.getEventContexts().stream().filter(EventContext::isContinueOnKeepAliveParticipant).forEach(e -> logger.info("Found 'ContinueOnKeepAlive' participant: " + e.getName()));
        this.startTestFunction = this.createStartTestFunction();
        if (this.waitForGoMessagesCount != 0) {
            logger.info("Wait for Go! messages is active, need " + this.waitForGoMessagesCount + " Go! messages to start!");
            this.messageBus.addReceiver(m -> this.checkMessageForGo(m, this.startTestFunction, this.waitForGoMessagesCount));
        }
    }

    private StartTestFunction createStartTestFunction() {
        return () -> {
            this.broadcaster.broadcastStartTest();
            this.eventSchedulerEngine.startKeepAliveThread(this.name, this.eventSchedulerContext.getKeepAliveInterval(), this.broadcaster, this.schedulerExceptionHandler.get());
            this.eventSchedulerEngine.startCustomEventScheduler(this.scheduleEvents, this.broadcaster);
        };
    }

    private void checkMessageForGo(EventMessage m, StartTestFunction startTestFunction, int totalGoMessages) {
        if ("go!".equalsIgnoreCase(m.getMessage())) {
            int count = this.goMessageCount.incrementAndGet();
            this.logger.info("Got 'Go! message' from " + m.getPluginName() + " now counted " + count + " 'Go! messages' of " + totalGoMessages + " needed.");
            if (count == totalGoMessages) {
                startTestFunction.start();
            }
        }
    }

    public void addKillSwitch(SchedulerExceptionHandler schedulerExceptionHandler) {
        this.schedulerExceptionHandler.set(schedulerExceptionHandler);
    }

    public void startSession() {
        boolean wasInActive = this.isSessionActive.compareAndSet(false, true);
        if (!wasInActive) {
            this.logger.warn("unexpected call to start session, session was active already, ignore call!");
        } else {
            this.broadcaster.broadcastBeforeTest();
            this.sendTestConfig();
            if (this.waitForGoMessagesCount == 0) {
                this.logger.info("start test session");
                this.startTestFunction.start();
            }
        }
    }

    public void stopSession() {
        boolean wasActive = this.isSessionActive.compareAndSet(true, false);
        if (!wasActive) {
            this.logger.warn("unexpected call to stop session, session was inactive already, ignoring call: please debug");
        } else {
            this.logger.info("stop test session.");
            this.eventSchedulerEngine.shutdownThreadsNow();
            this.broadcaster.broadcastAfterTest();
            this.logger.info("all broadcasts for stop test session are done");
        }
    }

    public boolean isSessionStopped() {
        return !this.isSessionActive.get();
    }

    public void abortSession() {
        boolean wasActive = this.isSessionActive.compareAndSet(true, false);
        if (!wasActive) {
            this.logger.warn("unexpected call to abort session, session was inactive already, ignoring call: please debug");
        } else {
            this.logger.info("test session abort called");
            this.eventSchedulerEngine.shutdownThreadsNow();
            this.broadcaster.broadcastAbortTest();
        }
    }

    public void checkResults() throws EventCheckFailureException {
        this.logger.info("check results called");
        List<EventCheck> eventChecks = this.broadcaster.broadcastCheck();
        this.logger.debug("event checks: " + eventChecks);
        boolean success = eventChecks.stream().allMatch(e -> e.getEventStatus() != EventStatus.FAILURE);
        this.logger.debug("checked " + eventChecks.size() + " event checks, all success: " + success);
        if (!success) {
            String failureMessage = eventChecks.stream().filter(e -> e.getEventStatus() == EventStatus.FAILURE).map(e -> String.format("class: '%s' eventId: '%s' message: '%s'", e.getEventClassName(), e.getEventId(), e.getMessage())).collect(Collectors.joining(", "));
            String message = String.format("event checks with failures found: [%s]", failureMessage);
            if (this.checkResultsEnabled) {
                this.logger.info("one or more event checks reported a failure: " + message);
                throw new EventCheckFailureException(message);
            }
            this.logger.warn("checkResultsEnabled is false, not throwing EventCheckFailureException with message: " + message);
        }
    }

    public String toString() {
        return "EventScheduler [testRunId:" + this.name + "]";
    }

    public EventSchedulerContext getEventSchedulerContext() {
        return this.eventSchedulerContext;
    }

    public void sendMessage(EventMessage message) {
        this.messageBus.send(message);
    }

    private void sendTestConfig() {
        Map<String, String> testConfigKeyValues = this.createTestConfigKeyValues(this.getEventSchedulerContext().getTestContext());
        String events = this.getEventSchedulerContext().getEventContexts().stream().map(EventContext::getName).sorted().collect(Collectors.joining("\n"));
        testConfigKeyValues.put("testEvents", events);
        testConfigKeyValues.put("scheduleScript", this.getEventSchedulerContext().getScheduleScript());
        EventMessage message = TestRunConfigUtil.createTestRunConfigMessageKeys("event-scheduler", testConfigKeyValues, "event-scheduler");
        this.sendMessage(message);
    }

    private Map<String, String> createTestConfigKeyValues(TestContext testContext) {
        HashMap<String, String> lines = new HashMap<String, String>();
        String prefix = "testContext.";
        lines.put(prefix + "testRunId", testContext.getTestRunId());
        lines.put(prefix + "testEnvironment", testContext.getTestEnvironment());
        lines.put(prefix + "annotations", testContext.getAnnotations());
        lines.put(prefix + "rampupTime", String.valueOf(testContext.getRampupTime()));
        lines.put(prefix + "constantLoadTime", String.valueOf(testContext.getConstantLoadTime()));
        lines.put(prefix + "workload", testContext.getWorkload());
        lines.put(prefix + "productName", testContext.getProductName());
        lines.put(prefix + "version", testContext.getVersion());
        lines.put(prefix + "dashboardName", testContext.getDashboardName());
        lines.put(prefix + "buildResultsUrl", testContext.getBuildResultsUrl());
        lines.put(prefix + "tags", String.join((CharSequence)"\n", testContext.getTags()));
        return lines;
    }

    private static interface StartTestFunction {
        public void start();
    }
}

