/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.eventscheduler;

import io.perfana.eventscheduler.EventBroadcaster;
import io.perfana.eventscheduler.EventBroadcasterAsync;
import io.perfana.eventscheduler.EventBroadcasterFactory;
import io.perfana.eventscheduler.EventMessageBusSimple;
import io.perfana.eventscheduler.EventScheduler;
import io.perfana.eventscheduler.EventSchedulerEngine;
import io.perfana.eventscheduler.api.CustomEvent;
import io.perfana.eventscheduler.api.Event;
import io.perfana.eventscheduler.api.EventGenerator;
import io.perfana.eventscheduler.api.EventGeneratorFactory;
import io.perfana.eventscheduler.api.EventGeneratorMetaProperty;
import io.perfana.eventscheduler.api.EventGeneratorProperties;
import io.perfana.eventscheduler.api.EventLogger;
import io.perfana.eventscheduler.api.SchedulerExceptionHandler;
import io.perfana.eventscheduler.api.TestContextInitializer;
import io.perfana.eventscheduler.api.TestContextInitializerFactory;
import io.perfana.eventscheduler.api.config.EventContext;
import io.perfana.eventscheduler.api.config.EventSchedulerContext;
import io.perfana.eventscheduler.api.config.TestContext;
import io.perfana.eventscheduler.api.message.EventMessageBus;
import io.perfana.eventscheduler.event.EventFactoryProvider;
import io.perfana.eventscheduler.event.TestContextInitializerFactoryProvider;
import io.perfana.eventscheduler.exception.EventSchedulerRuntimeException;
import io.perfana.eventscheduler.generator.EventGeneratorDefault;
import io.perfana.eventscheduler.generator.EventGeneratorFactoryDefault;
import io.perfana.eventscheduler.generator.EventGeneratorFactoryProvider;
import io.perfana.eventscheduler.log.EventLoggerDevNull;
import io.perfana.eventscheduler.log.EventLoggerWithName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
class EventSchedulerBuilderInternal {
    private final AtomicReference<EventSchedulerContext> eventSchedulerContext = new AtomicReference();
    private final Map<String, EventContext> eventContexts = new ConcurrentHashMap<String, EventContext>();
    private String customEventsText = "";
    private EventLogger logger = EventLoggerDevNull.INSTANCE;
    private EventFactoryProvider eventFactoryProvider;
    private TestContextInitializerFactoryProvider testContextInitializerFactoryProvider;
    private EventBroadcasterFactory eventBroadcasterFactory;
    private SchedulerExceptionHandler schedulerExceptionHandler;
    private EventSchedulerEngine eventSchedulerEngine;
    private EventMessageBus eventMessageBus;

    EventSchedulerBuilderInternal() {
    }

    public EventSchedulerBuilderInternal setEventSchedulerEngine(EventSchedulerEngine executorEngine) {
        this.eventSchedulerEngine = executorEngine;
        return this;
    }

    public EventSchedulerBuilderInternal setEventMessageBus(EventMessageBus eventMessageBus) {
        this.eventMessageBus = eventMessageBus;
        return this;
    }

    public EventSchedulerBuilderInternal setSchedulerExceptionHandler(SchedulerExceptionHandler callback) {
        this.schedulerExceptionHandler = callback;
        return this;
    }

    public EventSchedulerBuilderInternal setLogger(EventLogger logger) {
        this.logger = logger;
        return this;
    }

    public EventSchedulerBuilderInternal setEventSchedulerContext(EventSchedulerContext context) {
        this.eventSchedulerContext.set(context);
        return this;
    }

    public EventSchedulerBuilderInternal setTestContextInitializerFactoryProvider(TestContextInitializerFactoryProvider testContextInitializerFactoryProvider) {
        this.testContextInitializerFactoryProvider = testContextInitializerFactoryProvider;
        return this;
    }

    public EventScheduler build() {
        return this.build(null);
    }

    public EventScheduler build(ClassLoader classLoader) {
        if (this.eventSchedulerContext.get() == null) {
            throw new EventSchedulerRuntimeException("eventSchedulerContext must be set, it is null.");
        }
        this.initializeTestContext(classLoader);
        EventMessageBus messageBus = this.eventMessageBus == null ? new EventMessageBusSimple() : this.eventMessageBus;
        this.eventSchedulerContext.get().getEventContexts().forEach(this::addEvent);
        List<CustomEvent> customEvents = this.generateCustomEventSchedule(this.customEventsText, this.logger, classLoader);
        EventFactoryProvider myEventFactoryProvider = this.eventFactoryProvider == null ? EventFactoryProvider.createInstanceFromClasspath(classLoader) : this.eventFactoryProvider;
        this.eventContexts.values().stream().filter(eventConfig -> !eventConfig.isEnabled()).forEach(eventConfig -> this.logger.info("Event disabled: " + eventConfig.getName()));
        List<Event> events = this.eventContexts.values().stream().filter(EventContext::isEnabled).map(context -> this.createEvent(myEventFactoryProvider, (EventContext)context, this.eventSchedulerContext.get().getTestContext(), messageBus)).collect(Collectors.toList());
        EventBroadcasterFactory broadcasterFactory = this.eventBroadcasterFactory == null ? EventBroadcasterAsync::new : this.eventBroadcasterFactory;
        EventBroadcaster broadcaster = broadcasterFactory.create(events, this.logger);
        this.eventSchedulerEngine = this.eventSchedulerEngine == null ? new EventSchedulerEngine(this.logger) : this.eventSchedulerEngine;
        return new EventScheduler(broadcaster, customEvents, this.eventSchedulerContext.get(), messageBus, this.logger, this.eventSchedulerEngine, this.schedulerExceptionHandler);
    }

    private void initializeTestContext(ClassLoader classLoader) {
        TestContextInitializerFactoryProvider testContextInitProvider = this.testContextInitializerFactoryProvider == null ? TestContextInitializerFactoryProvider.createInstanceFromClasspath(classLoader) : this.testContextInitializerFactoryProvider;
        Map<String, EventContext> eventContextMap = this.eventSchedulerContext.get().getEventContexts().stream().collect(Collectors.toMap(e -> e.getClass().getName(), e -> e, (e1, e2) -> {
            this.logger.warn("found duplicate event context: " + e2.getEventFactory() + "-" + e2.getName());
            return e1;
        }));
        List<TestContextInitializerFactory> testContextInitializerFactories = testContextInitProvider.getTestContextInitializerFactories();
        List<TestContextInitializer> testContextInitializers = testContextInitializerFactories.stream().map(factory -> factory.create((EventContext)eventContextMap.get(factory.getEventContextClassname()), this.logger)).collect(Collectors.toList());
        this.logger.info("init test context");
        AtomicReference<TestContext> testContext = new AtomicReference<TestContext>(this.eventSchedulerContext.get().getTestContext());
        testContextInitializers.forEach(testContextInitializer -> {
            this.logger.info("found TestContextInitializer: " + testContextInitializer.getClass().getName());
            testContext.set(testContextInitializer.extendTestContext((TestContext)testContext.get()));
        });
        this.eventSchedulerContext.set(this.eventSchedulerContext.get().withTestContext(testContext.get()));
    }

    private Event createEvent(EventFactoryProvider provider, EventContext context, TestContext testContext, EventMessageBus messageBus) {
        String factoryClassName = context.getEventFactory();
        String eventName = context.getName();
        EventLoggerWithName eventLogger = new EventLoggerWithName(eventName, this.removeFactoryPostfix(factoryClassName), this.logger);
        this.logger.debug("create event: " + eventName + " with factory: " + factoryClassName + " and context: " + context);
        return provider.factoryByClassName(factoryClassName).orElseThrow(() -> new RuntimeException(factoryClassName + " not registered via META-INF/services")).create(context, testContext, messageBus, eventLogger);
    }

    private String removeFactoryPostfix(String factoryClassName) {
        int index = factoryClassName.indexOf("Factory");
        return index != -1 ? factoryClassName.substring(0, index) : factoryClassName;
    }

    private List<CustomEvent> generateCustomEventSchedule(String text, EventLogger logger, ClassLoader classLoader) {
        EventGenerator eventGenerator;
        if (text == null) {
            EventGeneratorProperties eventGeneratorProperties = new EventGeneratorProperties();
            EventLoggerWithName myLogger = new EventLoggerWithName("defaultFactory", EventGeneratorDefault.class.getName(), logger);
            eventGenerator = new EventGeneratorFactoryDefault().create(eventGeneratorProperties, myLogger);
        } else if (EventGeneratorProperties.hasLinesThatStartWithMetaPropertyPrefix(text)) {
            EventGeneratorProperties eventGeneratorProperties = new EventGeneratorProperties(text);
            String generatorClassname = eventGeneratorProperties.getMetaProperty(EventGeneratorMetaProperty.generatorFactoryClass.name());
            EventGeneratorFactory eventGeneratorFactory = this.findAndCreateEventScheduleGenerator(logger, generatorClassname, classLoader);
            EventLoggerWithName myLogger = new EventLoggerWithName("customFactory", generatorClassname, logger);
            eventGenerator = eventGeneratorFactory.create(eventGeneratorProperties, myLogger);
        } else {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eventSchedule", text);
            EventGeneratorProperties eventGeneratorProperties = new EventGeneratorProperties(properties);
            EventLoggerWithName myLogger = new EventLoggerWithName("defaultFactory", EventGeneratorDefault.class.getName(), logger);
            eventGenerator = new EventGeneratorFactoryDefault().create(eventGeneratorProperties, myLogger);
        }
        return eventGenerator.generate();
    }

    public EventSchedulerBuilderInternal setCustomEvents(String customEventsText) {
        if (customEventsText != null) {
            this.customEventsText = customEventsText;
        }
        return this;
    }

    private EventGeneratorFactory findAndCreateEventScheduleGenerator(EventLogger logger, String generatorFactoryClassname, ClassLoader classLoader) {
        EventGeneratorFactoryProvider provider = EventGeneratorFactoryProvider.createInstanceFromClasspath(logger, classLoader);
        EventGeneratorFactory generatorFactory = provider.find(generatorFactoryClassname);
        if (generatorFactory == null) {
            throw new EventSchedulerRuntimeException("unable to find EventScheduleGeneratorFactory implementation class: " + generatorFactoryClassname);
        }
        return generatorFactory;
    }

    private EventSchedulerBuilderInternal addEvent(EventContext eventContext) {
        EventContext existingEventContext = this.eventContexts.putIfAbsent(eventContext.getName(), eventContext);
        if (existingEventContext != null) {
            throw new EventSchedulerRuntimeException("Event name is not unique: " + eventContext.getName());
        }
        return this;
    }

    EventSchedulerBuilderInternal setEventFactoryProvider(EventFactoryProvider eventFactoryProvider) {
        this.eventFactoryProvider = eventFactoryProvider;
        return this;
    }

    EventSchedulerBuilderInternal setEventBroadcasterFactory(EventBroadcasterFactory eventBroadcasterFactory) {
        this.eventBroadcasterFactory = eventBroadcasterFactory;
        return this;
    }
}

